/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.internal.dialect;

import com.google.common.base.Function;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.internal.contribution.IncrementalModelContributor;
import org.eclipse.sirius.business.internal.contribution.ReferenceResolver;
import org.eclipse.sirius.description.contribution.Contribution;
import org.eclipse.sirius.description.contribution.ContributionProvider;
import org.eclipse.sirius.ext.emf.AllContents;
import org.eclipse.sirius.table.business.internal.dialect.TableContributionsFinder;
import org.eclipse.sirius.table.metamodel.table.description.TableDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public final class TableModelContributor
extends IncrementalModelContributor {
    public TableModelContributor(Function<Iterable<EObject>, Iterable<Contribution>> contributionFinder, ReferenceResolver resolver, Function<EObject, Object> idFunction) {
        super(contributionFinder, resolver, idFunction);
    }

    protected List<Contribution> findAllContributions(EObject targetModel, Iterable<EObject> sources) {
        this.contributionFinder = new TableContributionsFinder((TableDescription)targetModel){

            @Override
            protected String getSiriusURI(Viewpoint vp) {
                return TableModelContributor.this.getSiriusURI(vp);
            }
        };
        return super.findAllContributions(targetModel, sources);
    }

    protected void postProcess(EObject result) {
        this.incorporateAllReusedElements((TableDescription)result);
        this.removeContributions(result);
    }

    private void incorporateAllReusedElements(TableDescription result) {
        EList<EObject> imported = result.getImportedElements();
        for (EObject obj : AllContents.of((EObject)result, (boolean)true)) {
            for (EReference re : obj.eClass().getEAllReferences()) {
                if (!this.isReuseReference(re)) continue;
                for (EObject o : new EObjectQuery(obj).getValues(re)) {
                    if (EcoreUtil.isAncestor((EObject)result, (EObject)o)) continue;
                    imported.add((Object)o);
                }
            }
        }
    }

    private boolean isReuseReference(EReference re) {
        return !re.isContainment() && re.getName().startsWith("reused");
    }

    private void removeContributions(EObject obj) {
        if (obj instanceof ContributionProvider) {
            ((ContributionProvider)obj).getContributions().clear();
        }
        for (EObject child : obj.eContents()) {
            this.removeContributions(child);
        }
    }
}

