/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.apidocs;

import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;

public final class ClassOverrideDirectives {
    public String _id;
    public String _rev;
    private final String providerId = this.getClass().getSimpleName();
    private ITypeName type;
    private int numberOfSubclasses;
    private Map<IMethodName, Integer> overrides;

    public static ClassOverrideDirectives create(ITypeName type, int numberOfSubclasses, Map<IMethodName, Integer> overriddenMethods) {
        ClassOverrideDirectives res = new ClassOverrideDirectives();
        res.type = type;
        res.numberOfSubclasses = numberOfSubclasses;
        res.overrides = overriddenMethods;
        return res;
    }

    public int getNumberOfSubclasses() {
        return this.numberOfSubclasses;
    }

    public Map<IMethodName, Integer> getOverrides() {
        return this.overrides;
    }

    public void validate() {
        Checks.ensureIsTrue((boolean)"ClassOverrideDirectives".equals(this.providerId));
        Objects.requireNonNull(this.type);
        Checks.ensureIsGreaterOrEqualTo((double)this.numberOfSubclasses, (double)1.0, null);
        Checks.ensureIsFalse((boolean)this.overrides.isEmpty(), (String)"empty overrides not allowed.", (Object[])new Object[0]);
    }

    public ITypeName getType() {
        return this.type;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

