/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pmf.updatepmfmodel.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.pmf.pim.Application;
import org.eclipse.pmf.pim.DataForm;
import org.eclipse.pmf.pim.Library;
import org.eclipse.pmf.pim.PMFFactory;
import org.eclipse.pmf.pim.PMFPackage;
import org.eclipse.pmf.pim.Validator;
import org.eclipse.pmf.pim.data.DataType;
import org.eclipse.pmf.pim.impl.EClassToEventEntryMapImpl;
import org.eclipse.pmf.pim.transformation.CodeGenContext;
import org.eclipse.pmf.pim.transformation.TransformationFactory;
import org.eclipse.pmf.pim.ui.Button;
import org.eclipse.pmf.pim.ui.Container;
import org.eclipse.pmf.pim.ui.PropertiesPart;
import org.eclipse.pmf.pim.ui.PropertyTab;
import org.eclipse.pmf.pim.ui.UIEvent;
import org.eclipse.pmf.pim.ui.UiFactory;
import org.eclipse.pmf.pim.ui.UiPackage;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public class updateHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object[] result;
        String targetURI = "";
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select new file container");
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            targetURI = result[0].toString();
        }
        URI uri = URI.createURI((String)"platform:/plugin/org.eclipse.pmf.pim/model/pmf.genmodel", (boolean)true);
        try {
            Application rootObject = PMFFactory.eINSTANCE.createApplication();
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.getResource(uri, true);
            rootObject.importModel(resource);
            this.updatePMFModel(rootObject);
            this.createCodeGenContextForXWT(targetURI, "CodeGen.ctx", rootObject.getId());
            Library libObject = this.addLibraryXWT(targetURI, "Application.plb", rootObject.getId());
            Library libObjectEvents = this.addLibraryEvent(targetURI, "System.plb", rootObject.getId());
            rootObject.getLibraries().add((Object)libObject);
            rootObject.getLibraries().add((Object)libObjectEvents);
            URI fileURI = URI.createPlatformResourceURI((String)(String.valueOf(targetURI) + "/Application.pmf"), (boolean)true);
            ResourceSetImpl resourceSet1 = new ResourceSetImpl();
            Resource resource1 = resourceSet1.createResource(fileURI);
            resource1.getContents().add((Object)rootObject);
            resource1.save(Collections.EMPTY_MAP);
        }
        catch (IOException ex) {
            EcorePlugin.INSTANCE.log((Object)ex);
        }
        return null;
    }

    protected Library addLibraryXWT(String path, String fileName, String rootId) throws IOException {
        Library libObject = PMFFactory.eINSTANCE.createLibrary();
        libObject.setName("XWT Library");
        ArrayList<Validator> validators = new ArrayList<Validator>();
        Validator integerValidator = PMFFactory.eINSTANCE.createValidator();
        integerValidator.setId(String.valueOf(rootId) + ".validators" + ".IntegerValidator");
        integerValidator.setName("IntegerValidator");
        validators.add(integerValidator);
        Validator floatValidator = PMFFactory.eINSTANCE.createValidator();
        floatValidator.setId(String.valueOf(rootId) + ".validators" + ".FloatValidator");
        floatValidator.setName("FloatValidator");
        validators.add(floatValidator);
        Validator emailValidator = PMFFactory.eINSTANCE.createValidator();
        emailValidator.setId(String.valueOf(rootId) + ".validators" + ".EmailValidator");
        emailValidator.setName("EmailValidator");
        validators.add(emailValidator);
        Validator regexValidator = PMFFactory.eINSTANCE.createValidator();
        regexValidator.setId(String.valueOf(rootId) + ".validators" + ".RegexValidator");
        regexValidator.setName("RegexValidator");
        validators.add(regexValidator);
        libObject.eSet((EStructuralFeature)PMFPackage.eINSTANCE.getLibrary_Validators(), validators);
        URI fileURI = URI.createPlatformResourceURI((String)(String.valueOf(path) + "/" + fileName), (boolean)true);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(fileURI);
        resource.getContents().add((Object)libObject);
        resource.save(Collections.EMPTY_MAP);
        return libObject;
    }

    protected Library addLibraryEvent(String path, String fileName, String rootId) throws IOException {
        Library libObject = PMFFactory.eINSTANCE.createLibrary();
        libObject.setName("System");
        EcoreEMap uiEventsMap = new EcoreEMap(PMFPackage.Literals.ECLASS_TO_EVENT_ENTRY_MAP, EClassToEventEntryMapImpl.class, (InternalEObject)libObject, 11);
        BasicEList uiButtonEvents = new BasicEList();
        Button button = UiFactory.eINSTANCE.createButton();
        EClass eButton = button.eClass();
        UIEvent clickEvent = UiFactory.eINSTANCE.createUIEvent();
        clickEvent.setName("Click");
        clickEvent.setId("click");
        uiButtonEvents.add((Object)clickEvent);
        uiEventsMap.put((Object)eButton, (Object)uiButtonEvents);
        BasicEList uiUIElementEvents = new BasicEList();
        EClass eUIElement = (EClass)UiPackage.eINSTANCE.getEClassifier("UIElement");
        UIEvent exposeEvent = UiFactory.eINSTANCE.createUIEvent();
        exposeEvent.setName("Expose");
        exposeEvent.setId("Expose");
        UIEvent mouseInEvent = UiFactory.eINSTANCE.createUIEvent();
        mouseInEvent.setName("MouseIn");
        mouseInEvent.setId("MouseIn");
        UIEvent mouseOutEvent = UiFactory.eINSTANCE.createUIEvent();
        mouseOutEvent.setName("MouseOut");
        mouseOutEvent.setId("MouseOut");
        uiUIElementEvents.add((Object)exposeEvent);
        uiUIElementEvents.add((Object)mouseInEvent);
        uiUIElementEvents.add((Object)mouseOutEvent);
        uiEventsMap.put((Object)eUIElement, (Object)uiUIElementEvents);
        BasicEList uiListEvents = new BasicEList();
        EClass eList = (EClass)UiPackage.eINSTANCE.getEClassifier("ListView");
        UIEvent selectionEvent = UiFactory.eINSTANCE.createUIEvent();
        selectionEvent.setName("selection");
        selectionEvent.setId("selection");
        uiListEvents.add((Object)selectionEvent);
        uiEventsMap.put((Object)eList, (Object)uiListEvents);
        BasicEList uiTextEvents = new BasicEList();
        EClass eText = (EClass)UiPackage.eINSTANCE.getEClassifier("Text");
        UIEvent focusInEvent = UiFactory.eINSTANCE.createUIEvent();
        focusInEvent.setName("focusIn");
        focusInEvent.setId("focusIn");
        UIEvent focusOutEvent = UiFactory.eINSTANCE.createUIEvent();
        focusOutEvent.setName("focusOut");
        focusOutEvent.setId("focusOut");
        uiTextEvents.add((Object)focusInEvent);
        uiTextEvents.add((Object)focusOutEvent);
        uiEventsMap.put((Object)eText, (Object)uiTextEvents);
        libObject.eSet((EStructuralFeature)PMFPackage.Literals.LIBRARY__EVENTS, (Object)uiEventsMap.map());
        URI fileURI = URI.createPlatformResourceURI((String)(String.valueOf(path) + "/" + fileName), (boolean)true);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(fileURI);
        resource.getContents().add((Object)libObject);
        resource.save(Collections.EMPTY_MAP);
        return libObject;
    }

    protected void createCodeGenContextForXWT(String path, String fileName, String rootId) throws IOException {
        CodeGenContext codegenContext = TransformationFactory.eINSTANCE.createCodeGenContext();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(rootId);
        stringBuffer.append(".validators");
        stringBuffer.append(".IntegerValidator");
        codegenContext.getValidatorMap().put((Object)stringBuffer.toString(), (Object)stringBuffer.toString());
        stringBuffer.replace(0, stringBuffer.length(), "");
        stringBuffer.append(rootId);
        stringBuffer.append(".validators");
        stringBuffer.append(".FloatValidator");
        codegenContext.getValidatorMap().put((Object)stringBuffer.toString(), (Object)stringBuffer.toString());
        stringBuffer.replace(0, stringBuffer.length(), "");
        stringBuffer.append(rootId);
        stringBuffer.append(".validators");
        stringBuffer.append(".EmailValidator");
        codegenContext.getValidatorMap().put((Object)stringBuffer.toString(), (Object)stringBuffer.toString());
        stringBuffer.replace(0, stringBuffer.length(), "");
        stringBuffer.append(rootId);
        stringBuffer.append(".validators");
        stringBuffer.append(".RegexValidator");
        codegenContext.getValidatorMap().put((Object)stringBuffer.toString(), (Object)stringBuffer.toString());
        URI fileURI = URI.createPlatformResourceURI((String)(String.valueOf(path) + "/" + fileName), (boolean)true);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(fileURI);
        resource.getContents().add((Object)codegenContext);
        resource.save(Collections.EMPTY_MAP);
    }

    protected void updatePMFModel(Application app) {
        app.setName("org.eclipse.pmf.ui.properties");
        app.setId("org.eclipse.pmf.ui.properties");
        app.setDescription("PMF Properties View");
        Container container = UiFactory.eINSTANCE.createContainer();
        container.setEnabled(true);
        container.setVisible(true);
        ArrayList<PropertiesPart> propertiesParts = new ArrayList<PropertiesPart>();
        PropertiesPart propertiesPart = UiFactory.eINSTANCE.createPropertiesPart();
        propertiesPart.setEnabled(true);
        propertiesPart.setVisible(true);
        propertiesPart.setName("PMF Properties");
        PropertyTab dataBindingTab = UiFactory.eINSTANCE.createPropertyTab();
        PropertyTab documentTab = UiFactory.eINSTANCE.createPropertyTab();
        dataBindingTab.setId("dataBinding");
        dataBindingTab.setName("Databinding");
        documentTab.setId("documentation");
        documentTab.setName("Documentation");
        DataType typePMFObject = null;
        for (DataType type : app.getAllTypes()) {
            if (!"PMFObject".equals(type.getName())) continue;
            typePMFObject = type;
            break;
        }
        DataForm dataFormPMFObject = app.getDataFormFolder(typePMFObject).getDefaultDataForm();
        documentTab.setContent(dataFormPMFObject);
        propertiesPart.getTabs().add((Object)dataBindingTab);
        propertiesPart.getTabs().add((Object)documentTab);
        propertiesParts.add(propertiesPart);
        container.eSet((EStructuralFeature)UiPackage.eINSTANCE.getPropertiesPart_Tabs(), propertiesParts);
        app.setMain(container);
    }
}

