/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.contexts;

import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.internal.core.codeassist.contexts.StatementContext;
import org.eclipse.php.internal.core.codeassist.contexts.UseStatementContext;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPHPScriptRegion;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class NamespaceMemberContext
extends StatementContext {
    private IType[] namespaces;
    private int elementStart;
    private boolean isGlobal;

    @Override
    public boolean isValid(@NonNull ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        block9: {
            String nsName;
            if (!super.isValid(sourceModule, offset, requestor)) {
                return false;
            }
            if (this.getPHPVersion().isLessThan(PHPVersion.PHP5_3)) {
                return false;
            }
            TextSequence statementText = this.getStatementText();
            if (new UseStatementContext(){}.isValid(sourceModule, offset, requestor)) {
                return false;
            }
            int totalLength = statementText.length();
            int endPosition = PHPTextSequenceUtilities.readBackwardSpaces(statementText, totalLength);
            this.elementStart = PHPTextSequenceUtilities.readIdentifierStartIndex(statementText, endPosition, true);
            this.elementStart = PHPTextSequenceUtilities.readBackwardSpaces(statementText, this.elementStart);
            if (this.elementStart < 1) {
                return false;
            }
            String triggerText = statementText.subSequence(this.elementStart - 1, this.elementStart).toString();
            if (!triggerText.equals("\\")) {
                return false;
            }
            this.isGlobal = false;
            if (this.elementStart == 1) {
                this.isGlobal = true;
                return true;
            }
            int endNamespace = PHPTextSequenceUtilities.readBackwardSpaces(statementText, this.elementStart);
            int nsNameStart = PHPTextSequenceUtilities.readNamespaceStartIndex(statementText, endNamespace, false);
            String string = nsName = nsNameStart < 0 ? "" : statementText.subSequence(nsNameStart, this.elementStart).toString();
            if (nsName.equals("\\")) {
                this.isGlobal = true;
                return true;
            }
            try {
                this.namespaces = PHPModelUtils.getNamespaceOf(nsName, sourceModule, offset, null, null);
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block9;
                e.printStackTrace();
            }
        }
        return true;
    }

    public int getElementStart() {
        return this.elementStart;
    }

    public IType[] getNamespaces() {
        return this.namespaces;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    @Override
    public String getPrefix() throws BadLocationException {
        int statementLength;
        int prefixEnd;
        if (this.hasWhitespaceBeforeCursor()) {
            return "";
        }
        TextSequence statementText = this.getStatementText();
        int prefixStart = PHPTextSequenceUtilities.readIdentifierStartIndex(statementText, prefixEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, statementLength = statementText.length()), true);
        return prefixStart < 0 ? "" : statementText.subSequence(prefixStart, prefixEnd).toString();
    }

    @Override
    public int getReplacementEnd() throws BadLocationException {
        IPHPScriptRegion phpScriptRegion;
        ITextRegion nextRegion;
        ITextRegion phpToken = this.getPHPToken();
        if (phpToken.getType() == "PHP_NS_SEPARATOR" && phpToken.getLength() == "\\".length() && (nextRegion = (phpScriptRegion = this.getPHPScriptRegion()).getPHPToken(phpToken.getEnd())).getType() == "PHP_LABEL") {
            return this.getRegionCollection().getStartOffset() + phpScriptRegion.getStart() + nextRegion.getTextEnd();
        }
        return super.getReplacementEnd();
    }
}

