/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.contexts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.codeassist.CompletionCompanion;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.IPHPCompletionRequestor;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPHPScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.format.PHPHeuristicScanner;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceAlreadyExists;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public abstract class AbstractCompletionContext
implements ICompletionContext {
    public static final int NONE = 0;
    public static final int TRAIT_NAME = 1;
    public static final int TRAIT_KEYWORD = 2;
    private CompletionCompanion companion;
    private CompletionRequestor requestor;
    private ISourceModule sourceModule;
    private int offset;
    private PHPVersion phpVersion;
    private IStructuredDocument document;
    private IStructuredDocumentRegion structuredDocumentRegion;
    private ITextRegionCollection regionCollection;
    private IPHPScriptRegion phpScriptRegion;
    private String partitionType;
    private List<String> useTypes;

    @Override
    public void init(CompletionCompanion companion) {
        this.companion = companion;
    }

    protected CompletionCompanion getCompanion() {
        return this.companion;
    }

    @Override
    public boolean isValid(@NonNull ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        this.requestor = requestor;
        this.sourceModule = sourceModule;
        this.offset = offset;
        this.phpVersion = ProjectOptions.getPHPVersion(sourceModule.getScriptProject().getProject());
        try {
            this.document = this.determineDocument(sourceModule, requestor);
            if (this.document != null) {
                this.structuredDocumentRegion = this.determineStructuredDocumentRegion(this.document, offset);
                if (this.structuredDocumentRegion != null) {
                    this.regionCollection = this.determineRegionCollection(this.document, this.structuredDocumentRegion, offset);
                    if (this.regionCollection != null) {
                        this.phpScriptRegion = this.determinePHPRegion(this.document, this.regionCollection, offset);
                        if (this.phpScriptRegion != null) {
                            this.partitionType = this.determinePartitionType(this.regionCollection, this.phpScriptRegion, offset);
                            if (this.partitionType != null) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            PHPCorePlugin.log(e);
        }
        return false;
    }

    @Override
    public boolean isExclusive() {
        return false;
    }

    protected IStructuredDocumentRegion determineStructuredDocumentRegion(IStructuredDocument document, int offset) {
        IStructuredDocumentRegion sdRegion = null;
        int lastOffset = offset;
        while (sdRegion == null && lastOffset >= 0) {
            sdRegion = document.getRegionAtCharacterOffset(lastOffset);
            --lastOffset;
        }
        return sdRegion;
    }

    protected ITextRegionCollection determineRegionCollection(IStructuredDocument document, IStructuredDocumentRegion sdRegion, int offset) {
        IStructuredDocumentRegion regionCollection = sdRegion;
        ITextRegion textRegion = this.determineTextRegion(document, (ITextRegionCollection)sdRegion, offset);
        if (textRegion instanceof ITextRegionContainer) {
            regionCollection = (ITextRegionContainer)textRegion;
        }
        return regionCollection;
    }

    protected ITextRegion determineTextRegion(IStructuredDocument document, ITextRegionCollection regionCollection, int offset) {
        ITextRegion textRegion = offset == document.getLength() ? regionCollection.getLastRegion() : regionCollection.getRegionAtCharacterOffset(offset);
        return textRegion;
    }

    protected IPHPScriptRegion determinePHPRegion(IStructuredDocument document, ITextRegionCollection regionCollection, int offset) {
        ITextRegion textRegion = this.determineTextRegion(document, regionCollection, offset);
        IPHPScriptRegion phpScriptRegion = null;
        if (textRegion != null) {
            if (textRegion.getType() == "PHP_OPEN") {
                return null;
            }
            if (textRegion.getType() == "PHP_CLOSE") {
                if (regionCollection.getStartOffset(textRegion) == offset) {
                    textRegion = regionCollection.getRegionAtCharacterOffset(offset - 1);
                } else {
                    return null;
                }
            }
        }
        if (textRegion instanceof IPHPScriptRegion) {
            phpScriptRegion = (IPHPScriptRegion)textRegion;
        }
        return phpScriptRegion;
    }

    protected String determinePartitionType(ITextRegionCollection regionCollection, IPHPScriptRegion phpScriptRegion, int offset) throws BadLocationException {
        String regionType;
        int internalOffset = this.getOffset(offset, regionCollection, phpScriptRegion);
        String partitionType = phpScriptRegion.getPartition(internalOffset);
        if ((partitionType == "org.eclipse.php.PHP_MULTI_LINE_COMMENT" || partitionType == "org.eclipse.php.PHP_DOC") && (PHPPartitionTypes.isPHPMultiLineCommentStartRegion(regionType = phpScriptRegion.getPHPToken(internalOffset).getType()) || PHPPartitionTypes.isPHPDocStartRegion(regionType)) && phpScriptRegion.getPHPToken(internalOffset).getStart() == internalOffset) {
            partitionType = phpScriptRegion.getPartition(internalOffset - 1);
        }
        return partitionType;
    }

    protected IStructuredDocument determineDocument(ISourceModule module, CompletionRequestor requestor) throws ResourceAlreadyExists, IOException, CoreException {
        IDocument d;
        IStructuredDocument document = null;
        if (requestor instanceof IPHPCompletionRequestor && (d = ((IPHPCompletionRequestor)requestor).getDocument()) instanceof IStructuredDocument) {
            document = (IStructuredDocument)d;
        }
        if (document == null) {
            IStructuredModel structuredModel = null;
            try {
                IFile file = (IFile)module.getResource();
                if (file != null) {
                    if (file.exists()) {
                        structuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(file);
                        document = structuredModel != null ? structuredModel.getStructuredDocument() : StructuredModelManager.getModelManager().createStructuredDocumentFor(file);
                    } else {
                        document = StructuredModelManager.getModelManager().createNewStructuredDocumentFor(file);
                        document.set(module.getSource());
                    }
                }
            }
            finally {
                if (structuredModel != null) {
                    structuredModel.releaseFromRead();
                }
            }
        }
        return document;
    }

    public final PHPVersion getPHPVersion() {
        return this.phpVersion;
    }

    @NonNull
    public final ISourceModule getSourceModule() {
        return this.sourceModule;
    }

    public final IStructuredDocument getDocument() {
        return this.document;
    }

    public final ITextRegionCollection getRegionCollection() {
        return this.regionCollection;
    }

    public final IPHPScriptRegion getPHPScriptRegion() {
        return this.phpScriptRegion;
    }

    public final String getPartitionType() {
        return this.partitionType;
    }

    @NonNull
    public TextSequence getStatementText() {
        return PHPTextSequenceUtilities.getStatement(this.offset, this.structuredDocumentRegion, true);
    }

    public boolean hasWhitespaceBeforeCursor() {
        int statementEnd;
        TextSequence statementText = this.getStatementText();
        int statementLength = statementText.length();
        return statementLength != (statementEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, statementLength));
    }

    public boolean hasSpaceAtPosition(int offset) {
        try {
            return offset >= 0 && offset < this.document.getLength() && this.document.getChar(offset) == ' ';
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public final CompletionRequestor getCompletionRequestor() {
        return this.requestor;
    }

    public final int getOffset() {
        return this.offset;
    }

    public String getPreviousWord() throws BadLocationException {
        int statementLength;
        int wordEnd;
        TextSequence statementText = this.getStatementText();
        int wordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.phpVersion, statementText, wordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, statementLength = statementText.length()), true);
        if (wordStart < 0 || wordEnd < 0 || wordStart > wordEnd) {
            return "";
        }
        String previousWord = statementText.subSequence(wordStart, wordEnd).toString();
        if (this.hasWhitespaceBeforeCursor()) {
            return previousWord;
        }
        wordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, wordStart - 1);
        if ((wordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.phpVersion, statementText, wordEnd, true)) < 0 || wordEnd < 0 || wordStart > wordEnd) {
            return "";
        }
        previousWord = statementText.subSequence(wordStart, wordEnd).toString();
        return previousWord;
    }

    public String getPreviousWord(int times) throws BadLocationException {
        TextSequence statementText = this.getStatementText();
        int statementLength = statementText.length();
        int wordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, statementLength);
        int wordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.phpVersion, statementText, wordEnd, true);
        int i = 0;
        while (i < times - 1) {
            statementLength = wordStart;
            wordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, statementLength);
            wordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.phpVersion, statementText, wordEnd, true);
            ++i;
        }
        if (wordStart < 0 || wordEnd < 0 || wordStart > wordEnd) {
            return "";
        }
        String previousWord = statementText.subSequence(wordStart, wordEnd).toString();
        if (this.hasWhitespaceBeforeCursor()) {
            return previousWord;
        }
        wordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, wordStart - 1);
        if ((wordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.phpVersion, statementText, wordEnd, true)) < 0 || wordEnd < 0 || wordStart > wordEnd) {
            return "";
        }
        previousWord = statementText.subSequence(wordStart, wordEnd).toString();
        return previousWord;
    }

    public int getPreviousWordOffset(int times) throws BadLocationException {
        TextSequence statementText = this.getStatementText();
        int statementLength = statementText.length();
        int wordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, statementLength);
        int wordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.phpVersion, statementText, wordEnd, true);
        int i = 0;
        while (i < times - 1) {
            statementLength = wordStart;
            wordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, statementLength);
            wordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.phpVersion, statementText, wordEnd, true);
            ++i;
        }
        if (wordStart < 0 || wordEnd < 0 || wordStart > wordEnd) {
            return wordStart;
        }
        if (this.hasWhitespaceBeforeCursor()) {
            return wordStart;
        }
        wordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, wordStart - 1);
        wordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.phpVersion, statementText, wordEnd, true);
        return wordStart;
    }

    public ITextRegion getPHPToken() throws BadLocationException {
        return this.getPHPToken(this.offset);
    }

    public ITextRegion getPHPToken(int offset) throws BadLocationException {
        return this.phpScriptRegion.getPHPToken(this.getOffset(offset, this.regionCollection, this.phpScriptRegion));
    }

    private int getOffset(int offset, ITextRegionCollection regionCollection, IPHPScriptRegion phpScriptRegion) {
        int result = offset - regionCollection.getStartOffset() - phpScriptRegion.getStart() - 1;
        if (result < 0) {
            result = 0;
        }
        return result;
    }

    public String getPrefix() throws BadLocationException {
        return this.getPrefixWithoutProcessing();
    }

    public String getPrefixWithoutProcessing() {
        int statementLength;
        int prefixEnd;
        if (this.hasWhitespaceBeforeCursor()) {
            return "";
        }
        TextSequence statementText = this.getStatementText();
        int prefixStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.phpVersion, statementText, prefixEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, statementLength = statementText.length()), true);
        return prefixStart < 0 ? "" : statementText.subSequence(prefixStart, prefixEnd).toString();
    }

    public int getReplacementStart() throws BadLocationException {
        return this.offset - this.getPrefix().length();
    }

    public int getReplacementEnd() throws BadLocationException {
        ITextRegion phpToken = this.getPHPToken();
        int endOffset = this.regionCollection.getStartOffset() + this.phpScriptRegion.getStart() + phpToken.getTextEnd();
        if (PHPPartitionTypes.isPHPQuotesState(phpToken.getType())) {
            int index = this.offset;
            while (index < endOffset) {
                char charAt = this.document.getChar(index);
                if (Character.isWhitespace(charAt) || charAt == '\'' || charAt == '\"') {
                    return index;
                }
                ++index;
            }
        }
        return endOffset;
    }

    public ITextRegion getNextPHPToken() throws BadLocationException {
        ITextRegion phpToken = this.getPHPToken();
        while ((PHPPartitionTypes.isPHPCommentState((phpToken = this.phpScriptRegion.getPHPToken(phpToken.getEnd())).getType()) || phpToken.getType() == "WHITESPACE") && phpToken.getEnd() < this.phpScriptRegion.getLength()) {
        }
        return phpToken;
    }

    public ITextRegion getNextPHPToken(int times) throws BadLocationException {
        ITextRegion phpToken = null;
        int offset = this.offset;
        while (times-- > 0) {
            phpToken = this.getPHPToken(offset);
            while ((PHPPartitionTypes.isPHPCommentState((phpToken = this.phpScriptRegion.getPHPToken(phpToken.getEnd())).getType()) || phpToken.getType() == "WHITESPACE") && phpToken.getEnd() < this.phpScriptRegion.getLength()) {
            }
            if (phpToken == null) {
                return null;
            }
            offset = this.regionCollection.getStartOffset() + this.phpScriptRegion.getStart() + phpToken.getEnd();
        }
        return phpToken;
    }

    public String getNextWord() throws BadLocationException {
        ITextRegion nextPHPToken = this.getNextPHPToken();
        return this.document.get(this.regionCollection.getStartOffset() + this.phpScriptRegion.getStart() + nextPHPToken.getStart(), nextPHPToken.getTextLength());
    }

    public String getNextWord(int times) throws BadLocationException {
        ITextRegion nextPHPToken = this.getNextPHPToken(times);
        return this.document.get(this.regionCollection.getStartOffset() + this.phpScriptRegion.getStart() + nextPHPToken.getStart(), nextPHPToken.getTextLength());
    }

    public char getNextChar() throws BadLocationException {
        return this.getChar(this.offset);
    }

    public char getChar(int offset) throws BadLocationException {
        if (this.document.getLength() == offset) {
            return ' ';
        }
        return this.document.getChar(offset);
    }

    public int getUseTraitStatementContext() {
        return this.getUseTraitStatementContext(this.offset, this.structuredDocumentRegion);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getUseTraitStatementContext(int offset, IStructuredDocumentRegion sdRegion) {
        String type2;
        String type;
        int documentOffset;
        ArrayList<String> types = new ArrayList<String>();
        if (sdRegion == null) {
            sdRegion = this.structuredDocumentRegion;
        }
        if ((documentOffset = offset) == sdRegion.getEndOffset()) {
            --documentOffset;
        }
        ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(documentOffset);
        IStructuredDocumentRegion container = sdRegion;
        if (tRegion instanceof ITextRegionContainer) {
            container = (ITextRegionContainer)tRegion;
            tRegion = container.getRegionAtCharacterOffset(offset);
        }
        if (tRegion != null && tRegion.getType() == "PHP_CLOSE") {
            tRegion = container.getRegionAtCharacterOffset(container.getStartOffset() + tRegion.getStart() - 1);
        }
        if (tRegion != null && tRegion.getType() == "PHP_CONTENT") {
            IPHPScriptRegion phpScriptRegion = (IPHPScriptRegion)tRegion;
            try {
                int startOffset = container.getStartOffset() + phpScriptRegion.getStart();
                ITextRegion startTokenRegion = documentOffset == startOffset ? phpScriptRegion.getPHPToken(0) : phpScriptRegion.getPHPToken(offset - startOffset - 1);
                while (true) {
                    if (startTokenRegion.getStart() == 0) {
                        return 0;
                    }
                    if (!PHPPartitionTypes.isPHPCommentState(startTokenRegion.getType()) && startTokenRegion.getType() != "WHITESPACE") {
                        types.add(startTokenRegion.getType());
                    }
                    if (startTokenRegion.getType() != "PHP_CURLY_OPEN" && startTokenRegion.getType() != "PHP_INSTEADOF" && startTokenRegion.getType() != "PHP_SEMICOLON" && startTokenRegion.getType() != "PHP_AS") {
                        startTokenRegion = phpScriptRegion.getPHPToken(startTokenRegion.getStart() - 1);
                        continue;
                    }
                    break;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        if (types.size() == 1) {
            type = (String)types.get(0);
            if (type == "PHP_CURLY_OPEN" || type == "PHP_INSTEADOF" || type == "PHP_SEMICOLON") {
                return 1;
            }
            if (type == "PHP_AS") {
                return 2;
            }
            if (type != "PHP_INSTEADOF") return 0;
            return 2;
        }
        if (types.size() == 2) {
            String type1 = (String)types.get(0);
            String type3 = (String)types.get(1);
            try {
                if (type3 == "PHP_SEMICOLON" && type1 == "PHP_LABEL" && Character.isWhitespace(this.document.getChar(offset - 1))) {
                    return 2;
                }
            }
            catch (BadLocationException badLocationException) {}
            if (type3 != "PHP_CURLY_OPEN" && type3 != "PHP_INSTEADOF" && type3 != "PHP_SEMICOLON" && type1 != "PHP_LABEL") return 0;
            return 1;
        }
        if (types.size() == 3) {
            type = (String)types.get(0);
            String type1 = (String)types.get(1);
            type2 = (String)types.get(2);
            if (type != "PHP_LABEL" || type1 != "PHP_LABEL" || type2 != "PHP_SEMICOLON") return 0;
            return 2;
        } else {
            if (types.size() != 4) return 0;
            type = (String)types.get(0);
            String type1 = (String)types.get(1);
            type2 = (String)types.get(2);
            if (type != "PHP_LABEL" || type1 != "PHP_PAAMAYIM_NEKUDOTAYIM" || type2 != "PHP_LABEL") return 0;
            return 2;
        }
    }

    public boolean isInUseTraitStatement() {
        return this.isInUseTraitStatement(this.offset, this.structuredDocumentRegion);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean isInUseTraitStatement(int offset, IStructuredDocumentRegion sdRegion) {
        int documentOffset;
        PHPVersion phpVersion = ProjectOptions.getPHPVersion(this.sourceModule.getScriptProject().getProject());
        if (phpVersion.isLessThan(PHPVersion.PHP5_4)) {
            return false;
        }
        if (this.useTypes != null) {
            return true;
        }
        if (sdRegion == null) {
            sdRegion = this.structuredDocumentRegion;
        }
        if ((documentOffset = offset) == sdRegion.getEndOffset()) {
            --documentOffset;
        }
        ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(documentOffset);
        IStructuredDocumentRegion container = sdRegion;
        if (tRegion instanceof ITextRegionContainer) {
            container = (ITextRegionContainer)tRegion;
            tRegion = container.getRegionAtCharacterOffset(offset);
        }
        if (tRegion != null && tRegion.getType() == "PHP_CLOSE") {
            tRegion = container.getRegionAtCharacterOffset(container.getStartOffset() + tRegion.getStart() - 1);
        }
        if (tRegion != null && tRegion.getType() == "PHP_CONTENT") {
            IPHPScriptRegion phpScriptRegion = (IPHPScriptRegion)tRegion;
            try {
                int startOffset = container.getStartOffset() + phpScriptRegion.getStart();
                ITextRegion startTokenRegion = documentOffset == startOffset ? phpScriptRegion.getPHPToken(0) : phpScriptRegion.getPHPToken(offset - startOffset - 1);
                while (true) {
                    if (startTokenRegion.getStart() == 0) {
                        return false;
                    }
                    if (startTokenRegion.getType() == "PHP_CURLY_OPEN") {
                        TextSequence statementText1 = PHPTextSequenceUtilities.getStatement(startOffset + startTokenRegion.getStart() - 1, this.structuredDocumentRegion, true);
                        if ((startTokenRegion = phpScriptRegion.getPHPToken(startTokenRegion.getStart() - statementText1.length())).getType() == "PHP_USE") {
                            String[] types = statementText1.toString().trim().substring(3).trim().split(",");
                            this.useTypes = new ArrayList<String>();
                            String[] stringArray = types;
                            int n = types.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String type = stringArray[n2];
                                this.useTypes.add(type.trim());
                                ++n2;
                            }
                            return true;
                        }
                        return false;
                    }
                    if (startTokenRegion.getType() == "PHP_CURLY_CLOSE") {
                        return false;
                    }
                    startTokenRegion = phpScriptRegion.getPHPToken(startTokenRegion.getStart() - 1);
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }

    protected IModelElement getEnclosingElement() {
        try {
            TextSequence statementText;
            int statementStart;
            int close;
            int open;
            int offset = this.offset;
            PHPHeuristicScanner heuristicScanner = PHPHeuristicScanner.createHeuristicScanner((IDocument)this.document, offset, true);
            if (offset >= this.document.getLength()) {
                offset = this.document.getLength() - 1;
            }
            if ((open = heuristicScanner.findOpeningPeer(offset, -2, '{', '}')) > -1 && (close = heuristicScanner.findOpeningPeer(offset, -2, '}', '{')) > open && open == heuristicScanner.findOpeningPeer(close - 1, -2, '{', '}')) {
                open = heuristicScanner.findOpeningPeer(open - 1, -2, '{', '}');
            }
            int n = statementStart = (statementText = this.getStatementText()).length() > 0 ? statementText.getOriginalOffset(0) + 1 : -1;
            if (open < 0 && statementStart < 0) {
                return this.sourceModule.getElementAt(offset);
            }
            IModelElement elementAt = this.sourceModule.getElementAt(open);
            IModelElement elementAt2 = this.sourceModule.getElementAt(statementStart);
            if (elementAt == null && elementAt2 == null) {
                return this.sourceModule.getElementAt(offset);
            }
            if (elementAt instanceof ISourceReference && elementAt2 instanceof ISourceReference) {
                if (((ISourceReference)elementAt).getSourceRange().getOffset() > ((ISourceReference)elementAt2).getSourceRange().getOffset()) {
                    return elementAt;
                }
                return elementAt2;
            }
            if (elementAt != null) {
                return elementAt;
            }
            return elementAt2;
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
        catch (ModelException e) {
            Logger.logException(e);
        }
        return null;
    }

    @NonNull
    public final IStructuredDocumentRegion getStructuredDocumentRegion() {
        return this.structuredDocumentRegion;
    }

    public List<String> getUseTypes() {
        return this.useTypes;
    }
}

