/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.TraitPrecedence;
import org.eclipse.php.core.ast.nodes.TraitStatement;
import org.eclipse.php.core.ast.visitor.Visitor;

public class TraitPrecedenceStatement
extends TraitStatement {
    private TraitPrecedence precedence;

    public TraitPrecedenceStatement(int start, int end, AST ast, TraitPrecedence precedence) {
        super(start, end, ast, precedence);
        this.precedence = precedence;
    }

    public TraitPrecedenceStatement(AST ast) {
        super(ast);
    }

    public TraitPrecedence getPrecedence() {
        return this.precedence;
    }

    public void setPrecedence(TraitPrecedence precedence) {
        this.setExp(precedence);
        this.precedence = precedence;
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        if (!(other instanceof TraitPrecedenceStatement)) {
            return false;
        }
        return super.subtreeMatch(matcher, other);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<TraitPrecedenceStatement");
        this.appendInterval(buffer);
        buffer.append(">\n");
        this.precedence.toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("</TraitPrecedenceStatement>");
    }

    @Override
    ASTNode clone0(AST target) {
        TraitPrecedence precedence = ASTNode.copySubtree(target, this.getPrecedence());
        TraitPrecedenceStatement result = new TraitPrecedenceStatement(this.getStart(), this.getEnd(), target, precedence);
        return result;
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }
}

