/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.visitor.Visitor;

public class Comment
extends ASTNode {
    public static final int TYPE_SINGLE_LINE = 0;
    public static final int TYPE_MULTILINE = 1;
    public static final int TYPE_PHPDOC = 2;
    private int commentType;
    public static final SimplePropertyDescriptor COMMENT_TYPE_PROPERTY = new SimplePropertyDescriptor(Comment.class, "commentType", Integer.class, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<SimplePropertyDescriptor> list = new ArrayList<SimplePropertyDescriptor>(1);
        list.add(COMMENT_TYPE_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(list);
    }

    public Comment(int start, int end, AST ast, int type) {
        super(start, end, ast);
        this.setCommentType(type);
    }

    public Comment(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
    }

    public static String getCommentType(int type) {
        switch (type) {
            case 0: {
                return "singleLine";
            }
            case 1: {
                return "multiLine";
            }
            case 2: {
                return "phpDoc";
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<Comment");
        this.appendInterval(buffer);
        buffer.append(" commentType='").append(Comment.getCommentType(this.commentType)).append("'/>");
    }

    @Override
    public int getType() {
        return 16;
    }

    public int getCommentType() {
        return this.commentType;
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        Comment result = new Comment(this.getStart(), this.getEnd(), target, this.getCommentType());
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    final int internalGetSetIntProperty(SimplePropertyDescriptor property, boolean get, int value) {
        if (property == COMMENT_TYPE_PROPERTY) {
            if (get) {
                return this.getCommentType();
            }
            this.setCommentType(value);
            return 0;
        }
        return super.internalGetSetIntProperty(property, get, value);
    }

    public final void setCommentType(int value) {
        if (value != 1 && value != 2 && value != 0) {
            throw new IllegalArgumentException();
        }
        this.preValueChange(COMMENT_TYPE_PROPERTY);
        this.commentType = value;
        this.postValueChange(COMMENT_TYPE_PROPERTY);
    }
}

