/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.core.opxml.modeldata;

import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelImage;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.OprofileSAXHandler;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.XMLProcessor;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.modeldata.DependentProcessor;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.modeldata.SymbolsProcessor;
import org.xml.sax.Attributes;

public class ModelDataProcessor
extends XMLProcessor {
    private static final String IMAGE_TAG = "image";
    private static final String SYMBOLS_TAG = "symbols";
    private static final String DEPENDENT_TAG = "dependent";
    private static final String ATTR_IMAGENAME = "name";
    private static final String ATTR_COUNT = "count";
    private static final String ATTR_DEPCOUNT = "count";
    private OpModelImage image;
    private int imgSeen;
    private SymbolsProcessor _symbolsProcessor = new SymbolsProcessor();
    private DependentProcessor _dependentProcessor = new DependentProcessor();

    @Override
    public void reset(Object callData) {
        this.image = ((CallData)callData).opModelImage;
        this.imgSeen = 0;
    }

    @Override
    public void startElement(String name, Attributes attrs, Object callData) {
        if (name.equals(IMAGE_TAG)) {
            if (this.imgSeen == 0) {
                this.image.setName(this.validString(attrs.getValue(ATTR_IMAGENAME)));
                this.image.setCount(Integer.parseInt(attrs.getValue("count")));
            }
            ++this.imgSeen;
        } else if (name.equals(SYMBOLS_TAG)) {
            OprofileSAXHandler.getInstance(callData).push(this._symbolsProcessor);
        } else if (name.equals(DEPENDENT_TAG)) {
            this.image.setDepCount(Integer.parseInt(attrs.getValue("count")));
            OprofileSAXHandler.getInstance(callData).push(this._dependentProcessor);
        } else {
            super.startElement(name, attrs, callData);
        }
    }

    @Override
    public void endElement(String name, Object callData) {
        if (name.equals(IMAGE_TAG)) {
            if (this.imgSeen > 1) {
                this.image.setCount(-1);
                this.image.setDepCount(0);
                this.image.setDependents(null);
                this.image.setSymbols(null);
                this.image.setName("");
            }
        } else if (name.equals(SYMBOLS_TAG)) {
            this.image.setSymbols(this._symbolsProcessor.getSymbols());
        } else if (name.equals(DEPENDENT_TAG)) {
            this.image.setDependents(this._dependentProcessor.getImages());
        } else {
            super.endElement(name, callData);
        }
    }

    public static class CallData {
        public OpModelImage opModelImage;

        public CallData(OpModelImage im) {
            this.opModelImage = im;
        }
    }
}

