/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.wizards.CapabilityConfigurationPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ldt.core.buildpath.LuaExecutionEnvironment;
import org.eclipse.ldt.core.internal.LuaLanguageToolkit;
import org.eclipse.ldt.core.internal.buildpath.LuaExecutionEnvironmentBuildpathUtil;
import org.eclipse.ldt.core.internal.konekimigration.KonekiMigrationUtil;
import org.eclipse.ldt.ui.internal.Activator;
import org.eclipse.ldt.ui.wizards.Messages;
import org.eclipse.ldt.ui.wizards.pages.ConvertToLuaProjectMainPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;

public class ConvertToLuaProjectWizard
extends Wizard {
    private static final String DLTK_BUILDER_ID = "org.eclipse.dltk.core.scriptbuilder";
    private IProject project;
    private ConvertToLuaProjectMainPage mainpage;
    private CapabilityConfigurationPage buildPathpage;
    private IScriptProject scriptProject;

    public ConvertToLuaProjectWizard(IProject project) {
        Assert.isNotNull((Object)project);
        this.project = project;
        this.scriptProject = DLTKCore.create((IProject)project);
        ImageRegistry imageRegistry = Activator.getDefault().getImageRegistry();
        this.setDefaultPageImageDescriptor(imageRegistry.getDescriptor("icons/wizban/lua_newprj_wiz.png"));
        this.setWindowTitle(Messages.ConvertToLuaProjectWizard_wizardTitle);
    }

    public void addPages() {
        this.mainpage = new ConvertToLuaProjectMainPage("mainPage", this.project);
        this.addPage((IWizardPage)this.mainpage);
        this.buildPathpage = new CapabilityConfigurationPage("secondPage"){

            protected String getScriptNature() {
                return "org.eclipse.ldt.nature";
            }

            public void setVisible(boolean visible) {
                if (visible) {
                    this.init(ConvertToLuaProjectWizard.this.scriptProject, ConvertToLuaProjectWizard.this.getDefaultBuildpath(), true);
                }
                super.setVisible(visible);
            }
        };
        this.addPage((IWizardPage)this.buildPathpage);
    }

    private IBuildpathEntry[] getDefaultBuildpath() {
        IPath path;
        IBuildpathEntry newContainerEntry;
        LuaExecutionEnvironment executionEnvironement;
        Object[] rawBuildPath = new IBuildpathEntry[]{};
        if (this.mainpage.isKonekiMigration()) {
            try {
                IBuildpathEntry[] konekiRawBuildPath = this.scriptProject.getRawBuildpath();
                rawBuildPath = new IBuildpathEntry[konekiRawBuildPath.length];
                int i = 0;
                while (i < konekiRawBuildPath.length) {
                    IPath konekiPath = konekiRawBuildPath[i].getPath();
                    if (KonekiMigrationUtil.isValidKonekiExecutionEnvironmentBuildPath((IPath)konekiPath)) {
                        String ldtpath = konekiPath.toString().replaceAll("org\\.eclipse\\.koneki\\.ldt\\.ExecutionEnvironmentContainer", "org.eclipse.ldt.ExecutionEnvironmentContainer");
                        rawBuildPath[i] = DLTKCore.newContainerEntry((IPath)new Path(ldtpath));
                    } else {
                        rawBuildPath[i] = konekiRawBuildPath[i];
                    }
                    ++i;
                }
            }
            catch (ModelException e) {
                Activator.logWarning("unable to get koneki buildpath for project", e);
            }
        }
        if ((executionEnvironement = this.mainpage.getLuaExecutionEnvironement()) != null && !ArrayUtils.contains((Object[])rawBuildPath, (Object)(newContainerEntry = DLTKCore.newContainerEntry((IPath)(path = LuaExecutionEnvironmentBuildpathUtil.getLuaExecutionEnvironmentContainerPath((LuaExecutionEnvironment)executionEnvironement)))))) {
            IBuildpathEntry[] newBuildPath = new IBuildpathEntry[rawBuildPath.length + 1];
            System.arraycopy(rawBuildPath, 0, newBuildPath, 1, rawBuildPath.length);
            newBuildPath[0] = newContainerEntry;
            rawBuildPath = newBuildPath;
        }
        return rawBuildPath;
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor smonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    try {
                        IProjectDescription description = ConvertToLuaProjectWizard.this.project.getDescription();
                        String[] natures = description.getNatureIds();
                        String[] newNatures = new String[natures.length + 1];
                        System.arraycopy(natures, 0, newNatures, 0, natures.length);
                        newNatures[natures.length] = "org.eclipse.ldt.nature";
                        description.setNatureIds(newNatures);
                        ICommand[] commands = description.getBuildSpec();
                        boolean needToAdd = true;
                        int i = 0;
                        while (i < commands.length && needToAdd) {
                            if (ConvertToLuaProjectWizard.DLTK_BUILDER_ID.equals(commands[i].getBuilderName())) {
                                needToAdd = false;
                            }
                            ++i;
                        }
                        if (needToAdd) {
                            ICommand[] newcommands = new ICommand[commands.length + 1];
                            System.arraycopy(commands, 0, newcommands, 0, commands.length);
                            ICommand command = description.newCommand();
                            command.setBuilderName(ConvertToLuaProjectWizard.DLTK_BUILDER_ID);
                            newcommands[commands.length] = command;
                            description.setBuildSpec(newcommands);
                        } else {
                            description.setBuildSpec(commands);
                        }
                        ConvertToLuaProjectWizard.this.project.setDescription(description, (IProgressMonitor)smonitor.newChild(30));
                        if (ConvertToLuaProjectWizard.this.getContainer().getCurrentPage() == ConvertToLuaProjectWizard.this.buildPathpage) {
                            ConvertToLuaProjectWizard.this.buildPathpage.configureScriptProject((IProgressMonitor)smonitor.newChild(70));
                        } else {
                            ConvertToLuaProjectWizard.this.scriptProject.setRawBuildpath(ConvertToLuaProjectWizard.this.getDefaultBuildpath(), (IProgressMonitor)smonitor.newChild(70));
                        }
                        String grammar = ConvertToLuaProjectWizard.this.mainpage.getGrammar();
                        IEclipsePreferences node = new ProjectScope(ConvertToLuaProjectWizard.this.project).getNode(LuaLanguageToolkit.getDefault().getPreferenceQualifier());
                        node.put("Grammar__default_id", grammar);
                        node.flush();
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (BackingStoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            String message = NLS.bind((String)Messages.ConvertToLuaProjectWizard_convertFailedMessage, (Object)this.project.getName());
            Activator.logError(message, e);
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.ConvertToLuaProjectWizard_ConvertFailedDialogTitle, null, (IStatus)new Status(4, "org.eclipse.ldt.ui", message, e.getCause()));
            return false;
        }
        catch (InterruptedException e) {
            String message = NLS.bind((String)Messages.ConvertToLuaProjectWizard_convertFailedMessage, (Object)this.project.getName());
            Activator.logError(message, e);
            return false;
        }
        return true;
    }
}

