/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.project;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ProjectVersion;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.ui.handlers.project.AbstractProjectHandler;
import org.eclipse.jubula.client.ui.rcp.wizards.pages.UpdateReusedProjectsDialog;
import org.eclipse.jubula.tools.internal.exception.JBException;

public class UpdateReusedProjectHandler
extends AbstractProjectHandler {
    private Map<IReusedProjectPO, ProjectVersion> m_oldReusedProjects;

    public UpdateReusedProjectHandler() {
        this.searchOldReusedProjects();
    }

    protected Object executeImpl(ExecutionEvent event) {
        this.showUpdateReusedProjectDialog();
        return null;
    }

    public int showUpdateReusedProjectDialog() {
        UpdateReusedProjectsDialog dialog = new UpdateReusedProjectsDialog(this.getActiveShell(), this.m_oldReusedProjects);
        dialog.setHelpAvailable(true);
        return dialog.open();
    }

    private void searchOldReusedProjects() {
        this.m_oldReusedProjects = new HashMap<IReusedProjectPO, ProjectVersion>();
        for (IReusedProjectPO reusedProject : GeneralStorage.getInstance().getProject().getUsedProjects()) {
            try {
                ProjectVersion newestVersion = ProjectPM.findHighestVersionNumber((String)reusedProject.getProjectGuid());
                if (newestVersion == null || newestVersion.compareTo(reusedProject.getProjectVersion()) <= 0) continue;
                this.m_oldReusedProjects.put(reusedProject, newestVersion);
            }
            catch (JBException e) {
                e.printStackTrace();
            }
        }
    }

    public Map<IReusedProjectPO, ProjectVersion> getOldReusedProjects() {
        return this.m_oldReusedProjects;
    }

    public boolean isThereOldReusedProject() {
        return this.m_oldReusedProjects != null && !this.m_oldReusedProjects.isEmpty();
    }
}

