/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jubula.client.core.businessprocess.TestDataCubeBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ITestDataCategoryPO;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.IEditorOperation;
import org.eclipse.jubula.client.ui.rcp.dialogs.NewTestDataManagerDialog;
import org.eclipse.jubula.client.ui.rcp.editors.CentralTestDataEditor;
import org.eclipse.jubula.client.ui.rcp.handlers.AddNewTestDataCategoryHandler;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddNewTestDataManagerHandler
extends AbstractHandler {
    public Object execute(final ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof CentralTestDataEditor) {
            final CentralTestDataEditor ctdEditor = (CentralTestDataEditor)activePart;
            ctdEditor.getEditorHelper().doEditorOperation(new IEditorOperation(){

                @Override
                public void run(IPersistentObject workingPo) {
                    ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
                    String newName = AddNewTestDataManagerHandler.this.openDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), AddNewTestDataManagerHandler.getSetOfUsedNames(ctdEditor));
                    if (newName != null) {
                        AddNewTestDataManagerHandler.this.performOperation(ctdEditor, newName, selection);
                    }
                }
            });
        }
        return null;
    }

    public static Set<String> getSetOfUsedNames(CentralTestDataEditor ctdEditor) {
        ITestDataCategoryPO po = (ITestDataCategoryPO)ctdEditor.getEditorHelper().getEditSupport().getWorkVersion();
        return TestDataCubeBP.getSetOfUsedNames((ITestDataCategoryPO)po);
    }

    protected String openDialog(Shell parentShell, Set<String> usedNames) {
        NewTestDataManagerDialog newNameDialog = new NewTestDataManagerDialog(parentShell, usedNames);
        newNameDialog.setHelpAvailable(true);
        newNameDialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)newNameDialog);
        Plugin.getHelpSystem().setHelp((Control)newNameDialog.getShell(), "org.eclipse.jubula.client.ua.help.newTestDataCubeNameContextId");
        if (newNameDialog.open() == 0) {
            return newNameDialog.getName();
        }
        return null;
    }

    private void performOperation(CentralTestDataEditor ctdEditor, String newName, ISelection selection) {
        EditSupport es = ctdEditor.getEditorHelper().getEditSupport();
        ITestDataCategoryPO parent = AddNewTestDataCategoryHandler.getParent(selection, (ITestDataCategoryPO)es.getWorkVersion());
        ITestDataCubePO testdata = PoMaker.createTestDataCubePO((String)newName);
        parent.addTestData(testdata);
        ctdEditor.getEditorHelper().setDirty(true);
        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)testdata, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.onlyInEditor);
    }
}

