/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.dialogs;

import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jubula.client.core.businessprocess.CalcTypes;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.problems.ProblemType;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.osgi.util.NLS;

public class CNTypeProblemDialog {
    private CalcTypes m_calc;
    private IComponentNameCache m_cache;

    public CNTypeProblemDialog(CalcTypes calc, IComponentNameCache cache) {
        this.m_calc = calc;
        this.m_cache = cache;
    }

    public boolean canCommence(Map<String, ProblemType> problems) {
        StringBuilder msg = new StringBuilder();
        int num = 0;
        for (String guid : problems.keySet()) {
            List info = this.m_calc.getProblemInfo(guid);
            IComponentNamePO cN = this.m_cache.getResCompNamePOByGuid(guid);
            if (cN == null) continue;
            msg.append(cN.getName());
            msg.append(":");
            msg.append(" ");
            if (problems.get(guid).equals((Object)ProblemType.REASON_INCOMPATIBLE_MAP_TYPE)) {
                msg.append("\n");
                msg.append("Mapped to: ");
                msg.append("\"");
                msg.append((String)info.get(0));
                msg.append("\"");
                msg.append(",");
                msg.append(" ");
                msg.append("used as: ");
                msg.append("\"");
                msg.append((String)info.get(1));
                msg.append("\"");
                msg.append("\n");
            } else {
                msg.append("\n");
                int i = 0;
                while (i < 6) {
                    msg.append(" ");
                    ++i;
                }
                msg.append("Used as ");
                msg.append("\"");
                msg.append((String)info.get(0));
                msg.append("\"");
                msg.append(" and ");
                msg.append("\"");
                msg.append((String)info.get(1));
                msg.append("\"");
                msg.append("\n");
            }
            if (++num <= 10) continue;
            msg.append(".");
            msg.append(".");
            msg.append(".");
            msg.append("\n");
            break;
        }
        String message = NLS.bind((String)Messages.IncompatiblePairChangeDialogText, (Object)msg.toString());
        MessageDialog dialog = new MessageDialog(null, Messages.IncompatiblePairChangeDialogTitle, null, message, 3, new String[]{Messages.DialogMessageButton_YES, Messages.DialogMessageButton_NO}, 0);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        dialog.open();
        return dialog.getReturnCode() == 0;
    }

    public static boolean noProblemOrIgnore(IWritableComponentNameCache cache, INodePO workTC) {
        CalcTypes calc = new CalcTypes((IComponentNameCache)cache, workTC);
        calc.calculateTypes();
        Map problems = cache.getNewProblems(calc);
        if (!problems.isEmpty() && !new CNTypeProblemDialog(calc, (IComponentNameCache)cache).canCommence(problems)) {
            return false;
        }
        cache.storeLocalProblems(calc);
        return true;
    }
}

