/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers.dnd.objectmapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jubula.client.core.businessprocess.CompNameManager;
import org.eclipse.jubula.client.core.businessprocess.CompNameTypeManager;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IComponentNameReuser;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.ui.rcp.editors.ObjectMappingMultiPageEditor;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.internal.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.internal.xml.businessmodell.CompSystem;
import org.eclipse.osgi.util.NLS;

public class OMEditorDndSupport {
    private OMEditorDndSupport() {
    }

    public static boolean checkTypeCompatibilityAndMove(List<IComponentNamePO> compNamesToMove, IObjectMappingAssoziationPO target, ObjectMappingMultiPageEditor editor) {
        IWritableComponentNameCache compCache = editor.getCompNameCache();
        IObjectMappingCategoryPO unmappedTechnical = editor.getAut().getObjMap().getUnmappedTechnicalCategory();
        if (OMEditorDndSupport.checkProblemsAndStop(compNamesToMove, target, editor)) {
            return true;
        }
        for (IComponentNamePO compName : compNamesToMove) {
            String compNameGuid = compName.getGuid();
            if (target.getLogicalNames().contains(compNameGuid)) continue;
            IObjectMappingAssoziationPO oldAssoc = editor.getOmEditorBP().getAssociation(compNameGuid);
            compCache.changeReuse((IComponentNameReuser)target, null, compNameGuid);
            compCache.changeReuse((IComponentNameReuser)oldAssoc, compNameGuid, null);
            if (OMEditorDndSupport.getSection(target).equals(unmappedTechnical)) {
                IObjectMappingCategoryPO mapped = editor.getAut().getObjMap().getMappedCategory();
                IObjectMappingCategoryPO newCategory = editor.getOmEditorBP().createCategory(mapped, target.getCategory());
                target.getCategory().removeAssociation(target);
                newCategory.addAssociation(target);
            }
            OMEditorDndSupport.cleanupAssociation(editor, oldAssoc);
        }
        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)editor.getAut().getObjMap(), DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
        editor.getTreeViewer().setExpandedState((Object)target, true);
        return false;
    }

    private static boolean checkProblemsAndStop(List<IComponentNamePO> compNamesToMove, IObjectMappingAssoziationPO target, ObjectMappingMultiPageEditor editor) {
        ArrayList<IComponentNamePO> problems = new ArrayList<IComponentNamePO>();
        List availableComponents = ComponentBuilder.getInstance().getCompSystem().getComponents(editor.getAut().getToolkit(), true);
        String type = null;
        if (target.getTechnicalName() != null) {
            type = CompSystem.getComponentType((String)target.getTechnicalName().getSupportedClassName(), (Collection)availableComponents);
        }
        for (IComponentNamePO cN : compNamesToMove) {
            IComponentNamePO masterCN = CompNameManager.getInstance().getResCompNamePOByGuid(cN.getGuid());
            if (masterCN == null || masterCN.getUsageType().equals("guidancer.abstract.Unknown") || CompNameTypeManager.doesFirstTypeRealizeSecond((String)type, (String)masterCN.getUsageType())) continue;
            problems.add(masterCN);
        }
        if (problems.isEmpty()) {
            return false;
        }
        StringBuilder list = new StringBuilder();
        for (IComponentNamePO cN : problems) {
            list.append(" ");
            list.append(" ");
            list.append(" ");
            list.append(cN.getName());
            list.append(" ");
            list.append("[");
            list.append(CompSystemI18n.getString((String)cN.getUsageType()));
            list.append("]");
            list.append("\n");
        }
        String message = NLS.bind((String)Messages.IncompatibleMapDialogText, (Object)list.toString());
        MessageDialog dialog = new MessageDialog(null, Messages.IncompatibleMapDialogTitle, null, message, 3, new String[]{Messages.DialogMessageButton_YES, Messages.DialogMessageButton_NO}, 0);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        dialog.open();
        return dialog.getReturnCode() != 0;
    }

    private static void cleanupAssociation(ObjectMappingMultiPageEditor editor, IObjectMappingAssoziationPO assoc) {
        if (assoc != null && assoc.getLogicalNames().isEmpty()) {
            IObjectMappingCategoryPO fromCategory = assoc.getCategory();
            if (assoc.getTechnicalName() != null) {
                IObjectMappingCategoryPO unmappedTech = editor.getAut().getObjMap().getUnmappedTechnicalCategory();
                IObjectMappingCategoryPO newCategory = editor.getOmEditorBP().createCategory(unmappedTech, fromCategory);
                fromCategory.removeAssociation(assoc);
                newCategory.addAssociation(assoc);
            } else {
                fromCategory.removeAssociation(assoc);
            }
        }
    }

    public static void checkTypeCompatibilityAndMove(List<IComponentNamePO> compNamesToMove, IObjectMappingCategoryPO target, ObjectMappingMultiPageEditor editor) {
        IObjectMappingCategoryPO targetSection;
        IObjectMappingCategoryPO unmappedCat = editor.getAut().getObjMap().getUnmappedLogicalCategory();
        if (!unmappedCat.equals(targetSection = OMEditorDndSupport.getSection(target))) {
            return;
        }
        IWritableComponentNameCache compCache = editor.getCompNameCache();
        for (IComponentNamePO compName : compNamesToMove) {
            String compNameGuid = compName.getGuid();
            IObjectMappingAssoziationPO oldAssoc = editor.getOmEditorBP().getAssociation(compNameGuid);
            if (oldAssoc.getTechnicalName() == null) {
                oldAssoc.getCategory().removeAssociation(oldAssoc);
                target.addAssociation(oldAssoc);
                continue;
            }
            IObjectMappingAssoziationPO newAssoc = PoMaker.createObjectMappingAssoziationPO(null, new HashSet());
            editor.getAut().getObjMap().addAssociationToCache(newAssoc);
            compCache.changeReuse((IComponentNameReuser)newAssoc, null, compNameGuid);
            compCache.changeReuse((IComponentNameReuser)oldAssoc, compNameGuid, null);
            target.addAssociation(newAssoc);
            if (oldAssoc == null || !oldAssoc.getLogicalNames().isEmpty()) continue;
            IObjectMappingCategoryPO unmappedTech = editor.getAut().getObjMap().getUnmappedTechnicalCategory();
            IObjectMappingCategoryPO newCategory = editor.getOmEditorBP().createCategory(unmappedTech, oldAssoc.getCategory());
            oldAssoc.getCategory().removeAssociation(oldAssoc);
            newCategory.addAssociation(oldAssoc);
        }
        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)editor.getAut().getObjMap(), DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
        editor.getTreeViewer().refresh((Object)target);
        editor.getTreeViewer().setExpandedState((Object)target, true);
    }

    public static void checkAndMoveAssociations(List<IObjectMappingAssoziationPO> toMove, IObjectMappingCategoryPO target, ObjectMappingMultiPageEditor editor) {
        IObjectMappingCategoryPO unmappedTechNames = editor.getAut().getObjMap().getUnmappedTechnicalCategory();
        IObjectMappingCategoryPO newSection = OMEditorDndSupport.getSection(target);
        for (IObjectMappingAssoziationPO assoc : toMove) {
            IObjectMappingCategoryPO oldSection = OMEditorDndSupport.getSection(assoc);
            if (oldSection.equals(newSection)) {
                IObjectMappingCategoryPO fromCategory = assoc.getCategory();
                fromCategory.removeAssociation(assoc);
                target.addAssociation(assoc);
                continue;
            }
            if (!unmappedTechNames.equals(newSection)) continue;
            IObjectMappingCategoryPO unmappedCompNames = editor.getAut().getObjMap().getUnmappedLogicalCategory();
            IWritableComponentNameCache compCache = editor.getCompNameCache();
            for (String compNameGuid : new ArrayList(assoc.getLogicalNames())) {
                compCache.changeReuse((IComponentNameReuser)assoc, compNameGuid, null);
                IObjectMappingAssoziationPO compNameAssoc = PoMaker.createObjectMappingAssoziationPO(null, new HashSet());
                editor.getAut().getObjMap().addAssociationToCache(compNameAssoc);
                compCache.changeReuse((IComponentNameReuser)compNameAssoc, null, compNameGuid);
                unmappedCompNames.addAssociation(compNameAssoc);
            }
            IObjectMappingCategoryPO fromCategory = assoc.getCategory();
            fromCategory.removeAssociation(assoc);
            target.addAssociation(assoc);
        }
        if (!toMove.isEmpty()) {
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)editor.getAut().getObjMap(), DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
            editor.getTreeViewer().setExpandedState((Object)target, true);
        }
    }

    public static boolean canMoveAssociations(List<IObjectMappingAssoziationPO> toMove, IObjectMappingCategoryPO target, ObjectMappingMultiPageEditor editor) {
        for (IObjectMappingAssoziationPO assoc : toMove) {
            if (OMEditorDndSupport.canMove(assoc, target, editor)) continue;
            return false;
        }
        return true;
    }

    private static boolean canMove(IObjectMappingAssoziationPO assoc, IObjectMappingCategoryPO target, ObjectMappingMultiPageEditor editor) {
        IObjectMappingCategoryPO oldSection = OMEditorDndSupport.getSection(assoc);
        IObjectMappingCategoryPO newSection = OMEditorDndSupport.getSection(target);
        IObjectMappingCategoryPO unmappedTechnicalNames = editor.getAut().getObjMap().getUnmappedTechnicalCategory();
        return unmappedTechnicalNames.equals(newSection) || oldSection.equals(newSection);
    }

    public static boolean canMoveCompNames(IObjectMappingCategoryPO target, ObjectMappingMultiPageEditor editor) {
        return OMEditorDndSupport.getSection(target).equals(editor.getAut().getObjMap().getUnmappedLogicalCategory());
    }

    public static IObjectMappingCategoryPO getSection(IObjectMappingCategoryPO startCategory) {
        return startCategory != null ? startCategory.getSection() : null;
    }

    public static IObjectMappingCategoryPO getSection(IObjectMappingAssoziationPO assoc) {
        return assoc != null ? assoc.getSection() : null;
    }

    public static boolean moveCategories(List<IObjectMappingCategoryPO> cats, IObjectMappingCategoryPO targ) {
        ArrayList<IObjectMappingCategoryPO> topCats = new ArrayList<IObjectMappingCategoryPO>();
        for (IObjectMappingCategoryPO cat : cats) {
            boolean isTop = true;
            IObjectMappingCategoryPO par = cat;
            while (isTop && par != null) {
                if (!cats.contains(par = par.getParent())) continue;
                isTop = false;
            }
            if (!isTop) continue;
            topCats.add(cat);
        }
        OMEditorDndSupport.correctNames(topCats, targ);
        for (IObjectMappingCategoryPO cat : topCats) {
            cat.getParent().removeCategory(cat);
            targ.addCategory(cat);
        }
        return true;
    }

    private static void correctNames(List<IObjectMappingCategoryPO> cats, IObjectMappingCategoryPO target) {
        HashMap<String, Integer> nameMap = new HashMap<String, Integer>();
        for (IObjectMappingCategoryPO cat : target.getUnmodifiableCategoryList()) {
            nameMap.put(cat.getName(), 0);
        }
        int i = 0;
        while (i < cats.size()) {
            IObjectMappingCategoryPO next = cats.get(i);
            String name = next.getName();
            Integer val = (Integer)nameMap.get(name);
            if (val != null) {
                val = val + 1;
                next.setName(String.valueOf(name) + "_" + val);
                if (nameMap.containsKey(next.getName())) {
                    --i;
                } else {
                    nameMap.put(name, val);
                }
            }
            ++i;
        }
    }
}

