/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.teststyle.gui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.teststyle.checks.BaseCheck;
import org.eclipse.jubula.client.teststyle.problems.Problem;
import org.eclipse.jubula.client.teststyle.quickfix.Quickfix;

public class MarkerHandler {
    private static MarkerHandler instance;
    private IWorkspaceRoot m_res = ResourcesPlugin.getWorkspace().getRoot();
    private Map<Problem, IMarker> m_problems = new HashMap<Problem, IMarker>();
    private Map<IMarker, Problem> m_markers = new HashMap<IMarker, Problem>();

    private MarkerHandler() {
    }

    public static MarkerHandler getInstance() {
        if (instance == null) {
            instance = new MarkerHandler();
        }
        return instance;
    }

    public void add(Problem problem) {
        BaseCheck chk = problem.getCheck();
        Object obj = problem.getPO();
        try {
            IMarker marker = this.m_res.createMarker("org.eclipse.jubula.client.teststyle.csProblem");
            if (obj instanceof IPersistentObject) {
                marker.setAttribute("location", (Object)((IPersistentObject)obj).getName());
            } else {
                marker.setAttribute("location", obj);
            }
            marker.setAttribute("severity", chk.getSeverity().ordinal());
            marker.setAttribute("message", (Object)chk.getDescription());
            marker.setAttribute("sourceId", (Object)chk.getId());
            marker.setAttribute("userEditable", false);
            this.m_problems.put(problem, marker);
            this.m_markers.put(marker, problem);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void remove(Problem problem) {
        try {
            IMarker marker = this.m_res.findMarker(this.m_problems.get(problem).getId());
            marker.delete();
            this.m_problems.remove(problem);
            this.m_markers.remove(marker);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public Quickfix[] getResolutions(IMarker marker) {
        Quickfix[] fixes;
        Problem problem = this.m_markers.get(marker);
        Quickfix[] quickfixArray = fixes = problem.getCheck().getQuickfix(problem.getPO());
        int n = fixes.length;
        int n2 = 0;
        while (n2 < n) {
            Quickfix quickfix = quickfixArray[n2];
            quickfix.setSource(marker);
            ++n2;
        }
        return problem.getCheck().getQuickfix(problem.getPO());
    }

    public IMarker[] findOtherMarker(IMarker[] markers, IMarker source) {
        HashSet<IMarker> mLst = new HashSet<IMarker>();
        Problem sourceProblem = this.m_markers.get(source);
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            Problem p = this.m_markers.get(marker);
            if (p != null && !marker.equals((Object)source) && p.getCheck().equals(sourceProblem.getCheck())) {
                mLst.add(marker);
            }
            ++n2;
        }
        return mLst.toArray(new IMarker[mLst.size()]);
    }

    public Problem getProblemFromMarker(IMarker marker) {
        return this.m_markers.get(marker);
    }
}

