/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.ui.libprov.user.internal;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.common.project.facet.core.libprov.user.internal.DownloadableLibrary;
import org.eclipse.jst.common.project.facet.ui.internal.FacetedProjectFrameworkJavaExtUiPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.project.facet.ui.internal.util.GridLayoutUtil;

public final class DownloadLibraryWizardLicensePage
extends WizardPage {
    private Browser browser;
    private Button acceptLicenseCheckbox;

    public DownloadLibraryWizardLicensePage() {
        super("DownloadLibraryWizardLicensePage");
        this.setTitle(Resources.pageTitle);
        this.setDescription(Resources.pageDescription);
        this.setImageDescriptor(FacetedProjectFrameworkJavaExtUiPlugin.getImageDescriptor("images/wizban/download-library.png"));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutUtil.gl((int)1));
        this.browser = new Browser(composite, 2048);
        this.browser.setLayoutData((Object)GridLayoutUtil.gdfill());
        this.acceptLicenseCheckbox = new Button(composite, 32);
        this.acceptLicenseCheckbox.setLayoutData((Object)GridLayoutUtil.gd());
        this.acceptLicenseCheckbox.setText(Resources.acceptLicenseCheckboxLabel);
        this.acceptLicenseCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DownloadLibraryWizardLicensePage.this.getContainer().updateButtons();
            }
        });
        this.setControl((Control)composite);
    }

    public boolean isPageComplete() {
        return this.acceptLicenseCheckbox.getSelection();
    }

    public void setLibrary(DownloadableLibrary library) {
        String url = library == null ? null : library.getLicenseUrl();
        this.browser.setUrl(url != null ? url : "");
        this.acceptLicenseCheckbox.setSelection(url == null);
    }

    private static final class Resources
    extends NLS {
        public static String pageTitle;
        public static String pageDescription;
        public static String acceptLicenseCheckboxLabel;

        static {
            Resources.initializeMessages((String)DownloadLibraryWizardLicensePage.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

