/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.jgit.lfs.lib.AnyLongObjectId;

public class Lfs {
    private Path root;
    private Path objDir;
    private Path tmpDir;

    public Lfs(Path root) {
        this.root = root;
    }

    public Path getLfsRoot() {
        return this.root;
    }

    public Path getLfsTmpDir() {
        if (this.tmpDir == null) {
            this.tmpDir = this.root.resolve("tmp");
        }
        return this.tmpDir;
    }

    public Path getLfsObjDir() {
        if (this.objDir == null) {
            this.objDir = this.root.resolve("objects");
        }
        return this.objDir;
    }

    public Path getMediaFile(AnyLongObjectId id) {
        String idStr = id.name();
        return this.getLfsObjDir().resolve(idStr.substring(0, 2)).resolve(idStr.substring(2));
    }

    public Path createTmpFile() throws IOException {
        return Files.createTempFile(this.getLfsTmpDir(), null, null, new FileAttribute[0]);
    }
}

