/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs.server;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jgit.lfs.lib.AnyLongObjectId;
import org.eclipse.jgit.lfs.lib.LongObjectId;
import org.eclipse.jgit.lfs.server.LargeFileRepository;
import org.eclipse.jgit.lfs.server.LfsObject;
import org.eclipse.jgit.lfs.server.Response;
import org.eclipse.jgit.lfs.server.internal.LfsServerText;

abstract class TransferHandler {
    final LargeFileRepository repository;
    final List<LfsObject> objects;

    static TransferHandler forOperation(String operation, LargeFileRepository repository, List<LfsObject> objects) {
        switch (operation) {
            case "upload": {
                return new Upload(repository, objects);
            }
            case "download": {
                return new Download(repository, objects);
            }
        }
        throw new UnsupportedOperationException(MessageFormat.format(LfsServerText.get().unsupportedOperation, operation));
    }

    TransferHandler(LargeFileRepository repository, List<LfsObject> objects) {
        this.repository = repository;
        this.objects = objects;
    }

    abstract Response.Body process() throws IOException;

    private static class Download
    extends TransferHandler {
        Download(LargeFileRepository repository, List<LfsObject> objects) {
            super(repository, objects);
        }

        @Override
        Response.Body process() throws IOException {
            Response.Body body = new Response.Body();
            if (this.objects.size() > 0) {
                body.objects = new ArrayList<Response.ObjectInfo>();
                for (LfsObject o : this.objects) {
                    this.addObjectInfo(body, o);
                }
            }
            return body;
        }

        private void addObjectInfo(Response.Body body, LfsObject o) throws IOException {
            Response.ObjectInfo info = new Response.ObjectInfo();
            body.objects.add(info);
            info.oid = o.oid;
            info.size = o.size;
            LongObjectId oid = LongObjectId.fromString((String)o.oid);
            if (this.repository.getSize((AnyLongObjectId)oid) >= 0L) {
                info.actions = new HashMap<String, Response.Action>();
                info.actions.put("download", this.repository.getDownloadAction((AnyLongObjectId)oid));
            } else {
                info.error = new Response.Error();
                info.error.code = 404;
                info.error.message = MessageFormat.format(LfsServerText.get().objectNotFound, oid.getName());
            }
        }
    }

    private static class Upload
    extends TransferHandler {
        Upload(LargeFileRepository repository, List<LfsObject> objects) {
            super(repository, objects);
        }

        @Override
        Response.Body process() throws IOException {
            Response.Body body = new Response.Body();
            if (this.objects.size() > 0) {
                body.objects = new ArrayList<Response.ObjectInfo>();
                for (LfsObject o : this.objects) {
                    this.addObjectInfo(body, o);
                }
            }
            return body;
        }

        private void addObjectInfo(Response.Body body, LfsObject o) throws IOException {
            Response.ObjectInfo info = new Response.ObjectInfo();
            body.objects.add(info);
            info.oid = o.oid;
            info.size = o.size;
            LongObjectId oid = LongObjectId.fromString((String)o.oid);
            if (this.repository.getSize((AnyLongObjectId)oid) == -1L) {
                info.actions = new HashMap<String, Response.Action>();
                info.actions.put("upload", this.repository.getUploadAction((AnyLongObjectId)oid, o.size));
                Response.Action verify = this.repository.getVerifyAction((AnyLongObjectId)oid);
                if (verify != null) {
                    info.actions.put("verify", verify);
                }
            }
        }
    }
}

