/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.di;

import java.io.File;

import org.eclipse.core.runtime.IPath;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.epp.internal.logging.aeri.ide.IDEWorkflow;
import org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor;

/**
 * Scope: Server Context
 */
public class ServerStateLocationCreationFunction extends ContextFunction {

    @Override
    public Object compute(IEclipseContext context, String contextKey) {
        IPath stateLocation = (IPath) context.get(IDEWorkflow.CTX_BUNDLE_STATE_LOCATION);
        IServerDescriptor server = context.get(IServerDescriptor.class);
        File area = stateLocation.append(server.getId()).toFile();
        area.mkdirs();
        context.set(File.class, area);
        return area;
    }
}
