/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.util;

import java.io.File;
import java.net.URISyntaxException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;

public class RepositoryPathChecker {
    private boolean hasContent;
    private String errorMessage;

    public boolean check(String dir) {
        this.hasContent = false;
        this.errorMessage = null;
        if (dir.length() == 0) {
            this.errorMessage = CoreText.RepositoryPathChecker_errAbsoluteRepoPath;
            return false;
        }
        if (dir.startsWith("git clone")) {
            this.errorMessage = CoreText.RepositoryPathChecker_errNoCloneCommand;
            return false;
        }
        if (this.isURL(dir)) {
            this.errorMessage = CoreText.RepositoryPathChecker_errNoURL;
            return false;
        }
        File testFile = new File(dir);
        IPath path = Path.fromOSString((String)dir);
        String[] stringArray = path.segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            IStatus status = ResourcesPlugin.getWorkspace().validateName(segment, 2);
            if (!status.isOK()) {
                this.errorMessage = status.getMessage();
                return false;
            }
            ++n2;
        }
        if (!path.isAbsolute()) {
            this.errorMessage = NLS.bind((String)CoreText.RepositoryPathChecker_errNotAbsoluteRepoPath, (Object)dir);
            return false;
        }
        if (testFile.exists() && !testFile.isDirectory()) {
            this.errorMessage = NLS.bind((String)CoreText.RepositoryPathChecker_errNoDirectory, (Object)dir);
            return false;
        }
        this.hasContent = testFile.exists() && testFile.list().length > 0;
        return true;
    }

    private boolean isURL(String dir) {
        try {
            URIish u = new URIish(dir);
            return u.isRemote() || u.getScheme() != null;
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    public boolean hasContent() {
        return this.hasContent;
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }
}

