/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInstanceCache;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.IPDOMCPPTemplateParameter;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPClassSpecialization;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMInstanceCache;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMTemplateParameterArray;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPClassTemplateSpecialization
extends PDOMCPPClassSpecialization
implements ICPPClassTemplate,
ICPPInstanceCache {
    private static final int TEMPLATE_PARAMS = 79;
    protected static final int RECORD_SIZE = 83;
    private volatile IPDOMCPPTemplateParameter[] fTemplateParameters;

    public PDOMCPPClassTemplateSpecialization(PDOMCPPLinkage linkage, PDOMNode parent, ICPPClassTemplate template, PDOMBinding specialized) throws CoreException {
        super(linkage, parent, template, specialized);
        this.computeTemplateParameters(template);
        Database db = this.getDB();
        long rec = PDOMTemplateParameterArray.putArray(db, this.fTemplateParameters);
        db.putRecPtr(this.record + 79L, rec);
        PDOMCPPLinkage pDOMCPPLinkage = linkage;
        pDOMCPPLinkage.getClass();
        new PDOMCPPLinkage.ConfigureTemplateParameters(pDOMCPPLinkage, template.getTemplateParameters(), this.fTemplateParameters);
    }

    public PDOMCPPClassTemplateSpecialization(PDOMLinkage linkage, long bindingRecord) {
        super(linkage, bindingRecord);
    }

    @Override
    protected int getRecordSize() {
        return 83;
    }

    @Override
    public int getNodeType() {
        return 41;
    }

    @Override
    public ICPPTemplateParameter[] getTemplateParameters() {
        if (this.fTemplateParameters == null) {
            try {
                long rec = this.getDB().getRecPtr(this.record + 79L);
                this.fTemplateParameters = rec == 0L ? IPDOMCPPTemplateParameter.EMPTY_ARRAY : PDOMTemplateParameterArray.getArray(this, rec);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                this.fTemplateParameters = IPDOMCPPTemplateParameter.EMPTY_ARRAY;
            }
        }
        return this.fTemplateParameters;
    }

    @Override
    public ICPPTemplateInstance getInstance(ICPPTemplateArgument[] arguments) {
        return PDOMInstanceCache.getCache(this).getInstance(arguments);
    }

    @Override
    public void addInstance(ICPPTemplateArgument[] arguments, ICPPTemplateInstance instance) {
        PDOMInstanceCache.getCache(this).addInstance(arguments, instance);
    }

    @Override
    public ICPPTemplateInstance[] getAllInstances() {
        return PDOMInstanceCache.getCache(this).getAllInstances();
    }

    @Override
    public boolean isSameType(IType type) {
        ICPPTemplateParameter[] params2;
        PDOMNode node;
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (type instanceof PDOMNode && (node = (PDOMNode)((Object)type)).getPDOM() == this.getPDOM()) {
            return node.getRecord() == this.getRecord();
        }
        if (!(type instanceof ICPPClassSpecialization) || !(type instanceof ICPPTemplateDefinition) || type instanceof IProblemBinding) {
            return false;
        }
        ICPPClassSpecialization classSpec2 = (ICPPClassSpecialization)type;
        if (this.getKey() != classSpec2.getKey()) {
            return false;
        }
        if (!CharArrayUtils.equals(this.getNameCharArray(), classSpec2.getNameCharArray())) {
            return false;
        }
        ICPPTemplateParameter[] params1 = this.getTemplateParameters();
        if (params1 == (params2 = ((ICPPClassTemplate)type).getTemplateParameters())) {
            return true;
        }
        if (params1 == null || params2 == null) {
            return false;
        }
        if (params1.length != params2.length) {
            return false;
        }
        int i = 0;
        while (i < params1.length) {
            IType t2;
            IType t1;
            ICPPTemplateParameter p1 = params1[i];
            ICPPTemplateParameter p2 = params2[i];
            if (p1 instanceof IType && p2 instanceof IType) {
                t1 = (IType)((Object)p1);
                t2 = (IType)((Object)p2);
                if (!t1.isSameType(t2)) {
                    return false;
                }
            } else if (p1 instanceof ICPPTemplateNonTypeParameter && p2 instanceof ICPPTemplateNonTypeParameter) {
                t1 = ((ICPPTemplateNonTypeParameter)p1).getType();
                if (!(t1 == (t2 = ((ICPPTemplateNonTypeParameter)p2).getType()) || t1 != null && t2 != null && t1.isSameType(t2))) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        IIndexBinding owner1 = this.getOwner();
        IBinding owner2 = classSpec2.getOwner();
        if (!(owner1 instanceof ICPPClassType) || !(owner2 instanceof ICPPClassType)) {
            return false;
        }
        return ((ICPPClassType)((Object)owner1)).isSameType((ICPPClassType)owner2);
    }

    @Override
    public ICPPClassTemplatePartialSpecialization[] getPartialSpecializations() {
        IASTNode point = null;
        ICPPClassTemplate origTemplate = (ICPPClassTemplate)this.getSpecializedBinding();
        ICPPClassTemplatePartialSpecialization[] orig = origTemplate.getPartialSpecializations();
        ICPPClassTemplatePartialSpecialization[] spec = new ICPPClassTemplatePartialSpecialization[orig.length];
        ICPPClassSpecialization owner = (ICPPClassSpecialization)((Object)this.getOwner());
        int i = 0;
        while (i < orig.length) {
            spec[i] = (ICPPClassTemplatePartialSpecialization)owner.specializeMember(orig[i], point);
            ++i;
        }
        return spec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ICPPDeferredClassInstance asDeferredInstance() {
        PDOMInstanceCache cache;
        PDOMInstanceCache pDOMInstanceCache = cache = PDOMInstanceCache.getCache(this);
        synchronized (pDOMInstanceCache) {
            ICPPDeferredClassInstance dci = cache.getDeferredInstance();
            if (dci == null) {
                dci = CPPTemplates.createDeferredInstance(this);
                cache.putDeferredInstance(dci);
            }
            return dci;
        }
    }

    private void computeTemplateParameters(ICPPClassTemplate originalTemplate) {
        try {
            this.fTemplateParameters = PDOMTemplateParameterArray.createPDOMTemplateParameters((PDOMLinkage)this.getLinkage(), this, originalTemplate.getTemplateParameters());
        }
        catch (DOMException e) {
            CCorePlugin.log(e);
            this.fTemplateParameters = IPDOMCPPTemplateParameter.EMPTY_ARRAY;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            this.fTemplateParameters = IPDOMCPPTemplateParameter.EMPTY_ARRAY;
        }
    }
}

