/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.changegenerator;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTModification;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTModificationMap;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTModificationStore;

public class ModificationScopeStack {
    private final Deque<List<ASTModification>> scopeStack = new ArrayDeque<List<ASTModification>>();
    private final ASTModificationStore modStore;

    public ModificationScopeStack(ASTModificationStore modificationStore) {
        this.modStore = modificationStore;
        ArrayList<Object> nullModList = new ArrayList<Object>();
        nullModList.add(null);
        this.scopeStack.addFirst(nullModList);
    }

    public void pushScope(IASTNode node) {
        ArrayList<ASTModification> newMods = new ArrayList<ASTModification>();
        for (ASTModification peekMod : this.scopeStack.peek()) {
            ASTModificationMap nestedMods = this.modStore.getNestedModifications(peekMod);
            if (nestedMods == null) continue;
            newMods.addAll(nestedMods.getModificationsForNode(node));
        }
        if (!newMods.isEmpty()) {
            this.scopeStack.addFirst(newMods);
        }
    }

    private List<ASTModification> getNestedModifikationsForNode(IASTNode node) {
        ASTModificationMap rootModifications = this.modStore.getRootModifications();
        if (rootModifications == null) {
            return Collections.emptyList();
        }
        return rootModifications.getModificationsForNode(node);
    }

    public void popScope(IASTNode node) {
        ASTModification modification;
        List<ASTModification> peek = this.scopeStack.peek();
        if (peek != null && !peek.isEmpty() && (modification = peek.get(0)) != null) {
            if (modification.getKind() == ASTModification.ModificationKind.REPLACE) {
                if (modification.getTargetNode() == node) {
                    this.scopeStack.removeFirst();
                }
            } else if (modification.getNewNode() == node) {
                this.scopeStack.removeFirst();
            }
        }
    }

    public Collection<IASTNode> getModifiedNodes() {
        List<ASTModification> aktModList = this.scopeStack.peek();
        if (aktModList == null) {
            return this.getNestedModifiedNodes();
        }
        ArrayList<IASTNode> nodes = new ArrayList<IASTNode>();
        for (ASTModification modification : aktModList) {
            ASTModificationMap nestedModifications = this.modStore.getNestedModifications(modification);
            if (nestedModifications == null) continue;
            nodes.addAll(nestedModifications.getModifiedNodes());
        }
        return Collections.unmodifiableCollection(nodes);
    }

    private Collection<IASTNode> getNestedModifiedNodes() {
        ASTModificationMap rootModifications = this.modStore.getRootModifications();
        if (rootModifications == null) {
            return Collections.emptyList();
        }
        return rootModifications.getModifiedNodes();
    }

    public List<ASTModification> getModificationsForNode(IASTNode node) {
        List<ASTModification> aktModList = this.scopeStack.peek();
        if (aktModList == null) {
            return this.getNestedModifikationsForNode(node);
        }
        ArrayList<ASTModification> modForNodeList = new ArrayList<ASTModification>();
        for (ASTModification modification : aktModList) {
            ASTModificationMap nestedModifications = this.modStore.getNestedModifications(modification);
            if (nestedModifications == null) continue;
            modForNodeList.addAll(nestedModifications.getModificationsForNode(node));
        }
        return Collections.unmodifiableList(modForNodeList);
    }

    public void clean(IASTNode actualNode) {
        while (this.scopeStack.size() > 1) {
            for (IASTNode currentModifiedNode : this.getModifiedNodes()) {
                for (ASTModification currentMod : this.getModificationsForNode(currentModifiedNode)) {
                    if (currentMod.getNewNode() != actualNode) continue;
                    return;
                }
            }
            if (!this.nodeIsChildOfModifications(actualNode, this.scopeStack.getFirst())) {
                if (this.scopeStack.getFirst().get(0).getTargetNode().getTranslationUnit() == actualNode.getTranslationUnit()) {
                    this.scopeStack.removeFirst();
                    continue;
                }
                return;
            }
            return;
        }
    }

    private boolean nodeIsChildOfModifications(IASTNode actualNode, List<ASTModification> modifications) {
        for (ASTModification currentModification : modifications) {
            if (currentModification == null || !this.nodeIsChildOfModification(currentModification, actualNode)) continue;
            return true;
        }
        return false;
    }

    private boolean nodeIsChildOfModification(ASTModification modification, IASTNode actualNode) {
        IASTNode nodeToTest = actualNode;
        while (nodeToTest != null) {
            if (modification.getNewNode() == nodeToTest) {
                return true;
            }
            nodeToTest = nodeToTest.getParent();
        }
        return false;
    }
}

