/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.ui.frameworks.taskwizard.composites;

import org.eclipse.birt.core.ui.utils.UIHelper;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class MessageComposite
extends Composite
implements PaintListener,
DisposeListener {
    transient Image img = null;
    transient boolean bDisableImage = false;
    private String sTitle;
    private String sDescription;
    private Font foTitle = null;
    private Composite co = null;
    private Label laTitle = null;
    private Label laDescription = null;
    private ImageCanvas ic = null;

    public MessageComposite(Composite coParent, String sImagePath, String sTitle, String sDescription, boolean bDisableImage) {
        super(coParent, 0);
        this.sTitle = sTitle;
        this.sDescription = sDescription;
        this.bDisableImage = bDisableImage;
        if (!bDisableImage) {
            this.img = UIHelper.getImage(sImagePath);
        }
        this.setup();
    }

    final void update(String sTitle, String sDescription) {
        this.sTitle = sTitle;
        this.sDescription = sDescription;
        this.laTitle.setText(sTitle);
        this.laDescription.setText(sDescription);
    }

    public final void setBackground(Color cBG) {
        super.setBackground(cBG);
        this.co.setBackground(cBG);
        this.laTitle.setBackground(cBG);
        this.laDescription.setBackground(cBG);
        if (!this.bDisableImage) {
            this.ic.setBackground(cBG);
        }
    }

    private final void setup() {
        this.setLayout((Layout)new FillLayout());
        this.co = new Composite((Composite)this, 0);
        this.co.addPaintListener((PaintListener)this);
        GridLayout gl = new GridLayout();
        if (!this.bDisableImage) {
            gl.numColumns = 2;
        }
        this.co.setLayout((Layout)gl);
        this.laTitle = new Label(this.co, 64);
        FontData fd = this.laTitle.getFont().getFontData()[0];
        this.foTitle = new Font((Device)Display.getCurrent(), fd.getName(), fd.getHeight(), 1);
        this.laTitle.setFont(this.foTitle);
        this.laTitle.setBackground(Display.getCurrent().getSystemColor(13));
        this.laTitle.setText(this.sTitle);
        GridData gd = new GridData(768);
        this.laTitle.setLayoutData((Object)gd);
        this.laTitle.setAlignment(0x1000000);
        if (!this.bDisableImage) {
            this.ic = new ImageCanvas(this.co);
            gd = new GridData();
            gd.verticalSpan = 2;
            gd.verticalAlignment = 1;
            gd.horizontalIndent = 10;
            this.ic.setLayoutData(gd);
        }
        this.laDescription = new Label(this.co, 16449);
        this.laDescription.setText(this.sDescription);
        gd = new GridData(1808);
        gd.horizontalIndent = 10;
        this.laDescription.setLayoutData((Object)gd);
    }

    public void paintControl(PaintEvent pev) {
        Rectangle rCA = this.getClientArea();
        --rCA.width;
        --rCA.height;
        GC gc = pev.gc;
        gc.setForeground(Display.getCurrent().getSystemColor(15));
        gc.drawRectangle(rCA);
    }

    public void widgetDisposed(DisposeEvent dev) {
        this.foTitle.dispose();
    }

    private final class ImageCanvas
    extends Canvas
    implements PaintListener {
        private final Rectangle rSize;

        private ImageCanvas(Composite coParent) {
            super(coParent, 0);
            this.addPaintListener(this);
            this.rSize = new Rectangle(0, 0, MessageComposite.this.img.getImageData().width, MessageComposite.this.img.getImageData().height);
        }

        public void paintControl(PaintEvent pev) {
            GC gc = pev.gc;
            gc.drawImage(MessageComposite.this.img, 0, 0);
        }

        public final Rectangle getPreferredBounds() {
            return this.rSize;
        }
    }
}

