/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.ui.util;

import org.eclipse.actf.model.internal.ui.WebBrowserUtilForACTF;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.model.ui.IModelServiceHolder;
import org.eclipse.actf.model.ui.editor.DummyEditorInput;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTF;
import org.eclipse.actf.ui.util.PlatformUIUtil;
import org.eclipse.actf.util.logging.DebugPrintUtil;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ModelServiceUtils {
    public static IEditorPart launch(String string) {
        IWorkbenchPage iWorkbenchPage = PlatformUIUtil.getActivePage();
        if (iWorkbenchPage == null) {
            return null;
        }
        if (string != null && string.length() != 0) {
            string = string.trim();
            IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
            int n = 0;
            while (n < iEditorReferenceArray.length) {
                IModelService iModelService;
                IEditorPart iEditorPart = iEditorReferenceArray[n].getEditor(false);
                if (iEditorPart instanceof IModelServiceHolder && string.equals((iModelService = ((IModelServiceHolder)iEditorPart).getModelService()).getURL())) {
                    iWorkbenchPage.activate((IWorkbenchPart)iEditorPart);
                    iModelService.open(string);
                    return iEditorPart;
                }
                ++n;
            }
            try {
                return ModelServiceUtils.launch(string, ModelServiceUtils.getEditorId(string));
            }
            catch (EditorNotFoundException editorNotFoundException) {
                System.err.println("Editor not found: " + string);
            }
        }
        return null;
    }

    public static IEditorPart launchNew(String string) {
        IWorkbenchPage iWorkbenchPage = PlatformUIUtil.getActivePage();
        if (iWorkbenchPage == null) {
            return null;
        }
        if (string != null && string.length() != 0) {
            string = string.trim();
            try {
                return ModelServiceUtils.launchNew(string, ModelServiceUtils.getEditorId(string));
            }
            catch (EditorNotFoundException editorNotFoundException) {
                System.err.println("Editor not found: " + string);
            }
        }
        return null;
    }

    private static boolean isModelService(IEditorDescriptor iEditorDescriptor) {
        if (iEditorDescriptor == null) {
            return false;
        }
        return iEditorDescriptor.getId().indexOf("actf.model.ui") >= 0;
    }

    private static String getEditorId(String string) throws EditorNotFoundException {
        IEditorDescriptor iEditorDescriptor;
        int n;
        int n2;
        IEditorDescriptor[] iEditorDescriptorArray;
        IEditorDescriptor[] iEditorDescriptorArray2;
        IEditorDescriptor iEditorDescriptor2;
        IEditorRegistry iEditorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        if (!string.startsWith("http://") && !string.startsWith("https://")) {
            iEditorDescriptor2 = iEditorRegistry.getDefaultEditor(string);
            if (ModelServiceUtils.isModelService(iEditorDescriptor2)) {
                return iEditorDescriptor2.getId();
            }
            iEditorDescriptorArray = iEditorDescriptorArray2 = iEditorRegistry.getEditors(string);
            n2 = iEditorDescriptorArray2.length;
            n = 0;
            while (n < n2) {
                iEditorDescriptor = iEditorDescriptorArray[n];
                if (ModelServiceUtils.isModelService(iEditorDescriptor)) {
                    return iEditorDescriptor.getId();
                }
                ++n;
            }
        }
        if (ModelServiceUtils.isModelService(iEditorDescriptor2 = iEditorRegistry.getDefaultEditor("default.html"))) {
            return iEditorDescriptor2.getId();
        }
        iEditorDescriptorArray = iEditorDescriptorArray2 = iEditorRegistry.getEditors("default.html");
        n2 = iEditorDescriptorArray2.length;
        n = 0;
        while (n < n2) {
            iEditorDescriptor = iEditorDescriptorArray[n];
            if (ModelServiceUtils.isModelService(iEditorDescriptor)) {
                return iEditorDescriptor.getId();
            }
            ++n;
        }
        throw new EditorNotFoundException();
    }

    public static IEditorPart launch(String string, String string2) {
        IWorkbenchPage iWorkbenchPage = PlatformUIUtil.getActivePage();
        if (iWorkbenchPage == null) {
            return null;
        }
        string = string != null ? string.trim() : "";
        IEditorPart iEditorPart = ModelServiceUtils.getBlankBrowserEditorPart(string2);
        if (iEditorPart != null) {
            iWorkbenchPage.activate((IWorkbenchPart)iEditorPart);
            if (string != null) {
                ((IModelServiceHolder)iEditorPart).getModelService().open(string);
                return iEditorPart;
            }
        } else {
            Object object;
            IEditorRegistry iEditorRegistry;
            IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
            int n = 0;
            while (n < iEditorReferenceArray.length) {
                if (iEditorReferenceArray[n].getId().equals(string2) && (iEditorRegistry = iEditorReferenceArray[n].getPart(false)) instanceof IModelServiceHolder && string.equals((object = ((IModelServiceHolder)iEditorRegistry).getModelService()).getURL())) {
                    iWorkbenchPage.activate((IWorkbenchPart)iEditorRegistry);
                    return (IEditorPart)iEditorRegistry;
                }
                ++n;
            }
            try {
                String string3 = "";
                iEditorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
                object = iEditorRegistry.findEditor(string2);
                if (object != null) {
                    string3 = object.getLabel();
                    return iWorkbenchPage.openEditor((IEditorInput)new DummyEditorInput(string, string3), string2);
                }
                System.err.println("Editor not found: " + string2);
            }
            catch (PartInitException partInitException) {
                partInitException.printStackTrace();
            }
        }
        return null;
    }

    public static IEditorPart launchNew(String string, String string2) {
        IWorkbenchPage iWorkbenchPage = PlatformUIUtil.getActivePage();
        if (iWorkbenchPage == null) {
            return null;
        }
        string = string != null ? string.trim() : "";
        try {
            String string3 = "";
            IEditorRegistry iEditorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
            IEditorDescriptor iEditorDescriptor = iEditorRegistry.findEditor(string2);
            if (iEditorDescriptor != null) {
                string3 = iEditorDescriptor.getLabel();
                return iWorkbenchPage.openEditor((IEditorInput)new DummyEditorInput(string, string3), string2);
            }
            System.err.println("Editor not found: " + string2);
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
        }
        return null;
    }

    private static IEditorPart getBlankBrowserEditorPart(String string) {
        IEditorReference[] iEditorReferenceArray = PlatformUIUtil.getActivePage().getEditorReferences();
        int n = 0;
        while (n < iEditorReferenceArray.length) {
            IWorkbenchPart iWorkbenchPart;
            if (iEditorReferenceArray[n].getId().equals(string) && (iWorkbenchPart = iEditorReferenceArray[n].getPart(false)) instanceof IModelServiceHolder) {
                IModelService iModelService = ((IModelServiceHolder)iWorkbenchPart).getModelService();
                if (iModelService.getURL() == null) {
                    return (IEditorPart)iWorkbenchPart;
                }
                if (iModelService instanceof IWebBrowserACTF && ("about:blank".equals(iModelService.getURL()) || "".equals(iModelService.getURL()))) {
                    return (IEditorPart)iWorkbenchPart;
                }
            }
            ++n;
        }
        return null;
    }

    public static void openInExistingEditor(String string) {
        String string2;
        if (string == null) {
            return;
        }
        string = string.trim();
        IWorkbenchPage iWorkbenchPage = PlatformUIUtil.getActivePage();
        if (iWorkbenchPage == null) {
            return;
        }
        try {
            string2 = ModelServiceUtils.getEditorId(string);
        }
        catch (EditorNotFoundException editorNotFoundException) {
            System.err.println("Editor not found: " + string);
            return;
        }
        if (ModelServiceUtils.activateEditorPart(string2)) {
            IEditorPart iEditorPart = iWorkbenchPage.getActiveEditor();
            if (iEditorPart instanceof IModelServiceHolder) {
                ((IModelServiceHolder)iEditorPart).getModelService().open(string);
            } else {
                ModelServiceUtils.launch(string);
            }
        } else {
            ModelServiceUtils.launch(string);
        }
    }

    public static boolean activateEditorPart(String string) {
        if (string != null) {
            IWorkbenchPage iWorkbenchPage = PlatformUIUtil.getActivePage();
            if (iWorkbenchPage == null) {
                return false;
            }
            IEditorPart iEditorPart = iWorkbenchPage.getActiveEditor();
            if (iEditorPart != null && iEditorPart.getSite().getId().equals(string)) {
                return true;
            }
            IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
            int n = 0;
            while (n < iEditorReferenceArray.length) {
                DebugPrintUtil.devOrDebugPrintln((Object)iEditorReferenceArray[n].getId());
                if (iEditorReferenceArray[n].getId().equals(string) && (iEditorPart = iEditorReferenceArray[n].getEditor(false)) != null) {
                    iWorkbenchPage.activate((IWorkbenchPart)iEditorPart);
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public static IModelServiceHolder getActiveModelServiceHolder() {
        IEditorPart iEditorPart = PlatformUIUtil.getActiveEditor();
        if (iEditorPart != null && iEditorPart instanceof IModelServiceHolder) {
            return (IModelServiceHolder)iEditorPart;
        }
        if (iEditorPart != null) {
            DebugPrintUtil.devOrDebugPrintln((Object)("ModelServiceUtils: " + iEditorPart + " isn't IModelServiceHolder"));
        }
        return null;
    }

    public static IModelService getActiveModelService() {
        IModelServiceHolder iModelServiceHolder = ModelServiceUtils.getActiveModelServiceHolder();
        if (iModelServiceHolder != null) {
            return iModelServiceHolder.getModelService();
        }
        return null;
    }

    public static IEditorPart reopenInACTFBrowser() {
        String string = WebBrowserUtilForACTF.getUrl(PlatformUIUtil.getActiveEditor());
        if (string != null) {
            return ModelServiceUtils.launch(string);
        }
        return null;
    }

    private static class EditorNotFoundException
    extends Exception {
        private static final long serialVersionUID = -5760127077107164112L;

        private EditorNotFoundException() {
        }
    }
}

