/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.tts;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.actf.ai.tts.ITTSEngine;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class TTSRegistry {
    private static final String PRIORITY = "priority";
    private static final String TTS_EXTENSION = "org.eclipse.actf.ai.voice.TTSEngine";
    private static final String DEFAULT_TTS = "org.eclipse.actf.ai.tts.sapi.engine.SapiVoice";
    private static IConfigurationElement[] ttsElements;
    private static boolean[] availables;
    private static ITTSEngine[] INSTANCES;

    static {
        TTSRegistry.initialize();
    }

    private static void initialize() {
        ttsElements = Platform.getExtensionRegistry().getConfigurationElementsFor(TTS_EXTENSION);
        Arrays.sort(ttsElements, new Comparator<IConfigurationElement>(){

            @Override
            public int compare(IConfigurationElement iConfigurationElement, IConfigurationElement iConfigurationElement2) {
                String string = iConfigurationElement.getAttribute(TTSRegistry.PRIORITY);
                String string2 = iConfigurationElement2.getAttribute(TTSRegistry.PRIORITY);
                int n = 0;
                int n2 = 0;
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {}
                return n2 - n;
            }
        });
        availables = new boolean[ttsElements.length];
        INSTANCES = new ITTSEngine[ttsElements.length];
        int n = 0;
        while (n < ttsElements.length) {
            try {
                ITTSEngine iTTSEngine = (ITTSEngine)ttsElements[n].createExecutableExtension("class");
                if (iTTSEngine.isAvailable()) {
                    TTSRegistry.availables[n] = true;
                    TTSRegistry.INSTANCES[n] = iTTSEngine;
                }
            }
            catch (Exception exception) {
                TTSRegistry.availables[n] = false;
                TTSRegistry.INSTANCES[n] = null;
            }
            ++n;
        }
    }

    public static boolean isAvailable(String string) {
        try {
            int n = 0;
            while (n < ttsElements.length) {
                if (string.equals(ttsElements[n].getAttribute("id"))) {
                    return availables[n];
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public static String getDefaultEngine() {
        int n = 0;
        while (n < ttsElements.length) {
            if (availables[n]) {
                return ttsElements[n].getAttribute("id");
            }
            ++n;
        }
        return DEFAULT_TTS;
    }

    public static String[][] getLabelAndIds() {
        String[][] stringArray = new String[ttsElements.length][2];
        int n = 0;
        while (n < ttsElements.length) {
            stringArray[n][0] = ttsElements[n].getAttribute("name");
            stringArray[n][1] = availables[n] ? ttsElements[n].getAttribute("id") : "";
            ++n;
        }
        return stringArray;
    }

    public static ITTSEngine createTTSEngine(String string) {
        try {
            int n = 0;
            while (n < ttsElements.length) {
                if (string.equals(ttsElements[n].getAttribute("id"))) {
                    if (INSTANCES[n] == null || INSTANCES[n].isDisposed()) {
                        TTSRegistry.INSTANCES[n] = (ITTSEngine)ttsElements[n].createExecutableExtension("class");
                    }
                    return INSTANCES[n];
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }
}

