/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.util.ArrayList;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ValidatorBuilder;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ValidatorMetaData;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ValidatorStrategy;

public class JavascriptValidationStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private static final boolean DEBUG_VALIDATORS = Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.jsdt.ui/debug/reconcilerValidators"));
    private final String SSE_UI_ID = "org.eclipse.wst.sse.ui";
    private IDocument fDocument;
    private ValidatorStrategy fValidatorStrategy;
    private boolean fValidationEnabled = true;
    private ISourceViewer fSourceViewer;

    public JavascriptValidationStrategy(ISourceViewer viewer) {
        this.fSourceViewer = viewer;
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
        if (this.getValidatorStrategy() != null) {
            this.getValidatorStrategy().setDocument(document);
        }
    }

    private IDocument getDocument() {
        return this.fDocument;
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile((IRegion)dirtyRegion);
    }

    public void reconcile(IRegion partition) {
        ITypedRegion[] partitions = this.computePartitioning(partition);
        DirtyRegion dirty = null;
        int i = 0;
        while (i < partitions.length) {
            dirty = this.createDirtyRegion((IRegion)partitions[i], "__insert");
            if (this.getValidatorStrategy() != null) {
                this.getValidatorStrategy().reconcile(partitions[i], dirty);
            }
            ++i;
        }
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    public void initialReconcile() {
        int length = this.getDocument().getLength();
        this.reconcile((IRegion)new Region(0, length));
    }

    public void aboutToBeReconciled() {
        if (this.getValidatorStrategy() != null) {
            this.getValidatorStrategy().beginProcessing();
        }
    }

    protected ITypedRegion[] computePartitioning(IRegion dirtyRegion) {
        int drOffset = dirtyRegion.getOffset();
        int drLength = dirtyRegion.getLength();
        return this.computePartitioning(drOffset, drLength);
    }

    protected ITypedRegion[] computePartitioning(int drOffset, int drLength) {
        ITypedRegion[] tr = new ITypedRegion[]{};
        IDocument doc = this.getDocument();
        if (doc != null) {
            int docLength = doc.getLength();
            if (drOffset > docLength) {
                drOffset = docLength;
                drLength = 0;
            } else if (drOffset + drLength > docLength) {
                drLength = docLength - drOffset;
            }
            try {
                tr = TextUtilities.computePartitioning((IDocument)doc, (String)this.getDocumentPartitioning(), (int)drOffset, (int)drLength, (boolean)true);
            }
            catch (BadLocationException e) {
                String info = "dr: [" + drOffset + ":" + drLength + "] doc: [" + docLength + "] ";
                Status status = new Status(4, "org.eclipse.wst.jsdt.ui", 0, info, (Throwable)e);
                JavaScriptPlugin.getDefault().getLog().log((IStatus)status);
                tr = new ITypedRegion[]{};
            }
        }
        return tr;
    }

    protected DirtyRegion createDirtyRegion(IRegion region, String type) {
        return this.createDirtyRegion(region.getOffset(), region.getLength(), type);
    }

    protected DirtyRegion createDirtyRegion(int offset, int length, String type) {
        DirtyRegion durty = null;
        IDocument doc = this.getDocument();
        if (doc != null) {
            int docLen = doc.getLength();
            if (offset > docLen) {
                offset = docLen;
                length = 0;
            } else if (offset + length >= docLen) {
                length = docLen - offset;
            }
            try {
                durty = new DirtyRegion(offset, length, type, doc.get(offset, length));
            }
            catch (BadLocationException e) {
                String info = "dr: [" + offset + ":" + length + "] doc: [" + docLen + "] ";
                Status status = new Status(4, "org.eclipse.wst.jsdt.ui", 0, info, (Throwable)e);
                JavaScriptPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
        return durty;
    }

    protected String getDocumentPartitioning() {
        return "___java_partitioning";
    }

    protected ISourceViewer getTextViewer() {
        return this.fSourceViewer;
    }

    protected ValidatorStrategy getValidatorStrategy() {
        ValidatorStrategy validatorStrategy = null;
        if (this.fValidatorStrategy == null && this.fValidationEnabled) {
            if (this.getTextViewer() instanceof ISourceViewer) {
                ISourceViewer viewer = this.getTextViewer();
                String contentTypeId = this.getContentType();
                if (contentTypeId != null) {
                    Status status;
                    String info;
                    validatorStrategy = new ValidatorStrategy(viewer, contentTypeId);
                    ValidatorBuilder vBuilder = new ValidatorBuilder();
                    ValidatorMetaData[] vmds = vBuilder.getValidatorMetaData("org.eclipse.wst.sse.ui");
                    ArrayList<ValidatorMetaData> enabledValidators = new ArrayList<ValidatorMetaData>(1);
                    boolean foundSpecificContentTypeValidators = false;
                    int i = 0;
                    while (i < vmds.length) {
                        if (vmds[i].mustHandleContentType(contentTypeId)) {
                            if (DEBUG_VALIDATORS) {
                                info = String.valueOf(contentTypeId) + " using specific validator " + vmds[i].getValidatorId();
                                status = new Status(1, "org.eclipse.wst.jsdt.ui", info);
                                JavaScriptPlugin.getDefault().getLog().log((IStatus)status);
                            }
                            foundSpecificContentTypeValidators = true;
                            enabledValidators.add(vmds[i]);
                        }
                        ++i;
                    }
                    if (!foundSpecificContentTypeValidators) {
                        i = 0;
                        while (i < vmds.length) {
                            if (vmds[i].canHandleContentType(contentTypeId)) {
                                if (DEBUG_VALIDATORS) {
                                    info = String.valueOf(contentTypeId) + " using inherited(?) validator " + vmds[i].getValidatorId();
                                    status = new Status(1, "org.eclipse.wst.jsdt.ui", info);
                                    JavaScriptPlugin.getDefault().getLog().log((IStatus)status);
                                }
                                enabledValidators.add(vmds[i]);
                            }
                            ++i;
                        }
                    }
                    i = 0;
                    while (i < enabledValidators.size()) {
                        validatorStrategy.addValidatorMetaData((ValidatorMetaData)enabledValidators.get(i));
                        ++i;
                    }
                }
            }
            this.fValidatorStrategy = validatorStrategy;
        } else if (this.fValidatorStrategy != null && this.fValidationEnabled) {
            validatorStrategy = this.fValidatorStrategy;
        }
        return validatorStrategy;
    }

    private String getContentType() {
        ITextFileBuffer textFileBuffer;
        IDocument doc = this.getDocument();
        if (doc == null) {
            return null;
        }
        ITextFileBufferManager textFileBufferManager = FileBuffers.getTextFileBufferManager();
        if (textFileBufferManager != null && (textFileBuffer = textFileBufferManager.getTextFileBuffer(doc)) != null && textFileBuffer.getLocation() != null) {
            try {
                IContentType ct = textFileBuffer.getContentType();
                if (ct != null) {
                    return ct.getId();
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }
}

