/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryregistry.properties;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeEntry;

public class QuerySpecificationPropertySection
extends AbstractPropertySection {
    private QueryRegistryTreeEntry entry;
    private CLabel fqnText;
    private CLabel sourceText;
    private Button loadButton;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        Composite composite = factory.createFlatFormComposite(parent);
        CLabel fqnLabel = factory.createCLabel(composite, "Fully qualified name:");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 10);
        fqnLabel.setLayoutData((Object)data);
        this.fqnText = factory.createCLabel(composite, "");
        data = new FormData();
        data.left = new FormAttachment((Control)fqnLabel, 5, 131072);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)fqnLabel, 0, 0x1000000);
        this.fqnText.setLayoutData((Object)data);
        CLabel sourceLabel = factory.createCLabel(composite, "Connector identifier:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.fqnText, 0);
        sourceLabel.setLayoutData((Object)data);
        this.sourceText = factory.createCLabel(composite, "");
        data = new FormData();
        data.left = new FormAttachment((Control)sourceLabel, 5, 131072);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)sourceLabel, 0, 0x1000000);
        this.sourceText.setLayoutData((Object)data);
        this.loadButton = factory.createButton(composite, "Load query specification details", 0);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.sourceText, 0);
        this.loadButton.setLayoutData((Object)data);
        this.loadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (QuerySpecificationPropertySection.this.entry.load()) {
                    QuerySpecificationPropertySection.this.refresh();
                }
            }
        });
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        Assert.isTrue((boolean)(input instanceof QueryRegistryTreeEntry));
        this.entry = (QueryRegistryTreeEntry)input;
    }

    public void refresh() {
        this.fqnText.setText(this.entry.getEntry().getFullyQualifiedName());
        this.sourceText.setText(this.entry.getEntry().getSourceIdentifier());
        this.loadButton.setEnabled(!this.entry.isLoaded());
    }
}

