/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.trace;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;

@NonNullByDefault
public final class CtfUtils {
    private CtfUtils() {
    }

    public static @Nullable String getTracerName(CtfTmfTrace trace) {
        String str = trace.getEnvironment().get("tracer_name");
        if (str == null) {
            return null;
        }
        return str.replaceAll("^\"|\"$", "");
    }

    public static int getTracerMajorVersion(CtfTmfTrace trace) {
        String str = trace.getEnvironment().get("tracer_major");
        if (str == null) {
            return -1;
        }
        try {
            int ret = Integer.parseInt(str);
            return ret;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static int getTracerMinorVersion(CtfTmfTrace trace) {
        String str = trace.getEnvironment().get("tracer_minor");
        if (str == null) {
            return -1;
        }
        try {
            int ret = Integer.parseInt(str);
            return ret;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }
}

