/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.context;

import org.eclipse.tracecompass.internal.tmf.ctf.core.trace.iterator.CtfIterator;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.ctf.core.context.CtfLocation;
import org.eclipse.tracecompass.tmf.ctf.core.context.CtfLocationInfo;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;

public class CtfTmfContext
implements ITmfContext {
    private CtfLocation fCurLocation;
    private long fCurRank;
    private final CtfTmfTrace fTrace;

    public CtfTmfContext(CtfTmfTrace ctfTmfTrace) {
        this.fTrace = ctfTmfTrace;
        this.fCurLocation = new CtfLocation(new CtfLocationInfo(0L, 0L));
    }

    public long getRank() {
        return this.fCurRank;
    }

    public synchronized ITmfLocation getLocation() {
        return this.fCurLocation;
    }

    public boolean hasValidRank() {
        return this.fCurRank != CtfLocation.INVALID_LOCATION.getTimestamp();
    }

    public synchronized void setLocation(ITmfLocation location) {
        if (location instanceof CtfLocation) {
            CtfLocation ctfLocation = (CtfLocation)location;
            if (location.getLocationInfo().equals(CtfLocation.INVALID_LOCATION)) {
                this.fCurLocation = ctfLocation;
            } else {
                CtfIterator iterator = this.getIterator();
                iterator.seek(ctfLocation.getLocationInfo());
                this.fCurLocation = iterator.getLocation();
            }
        } else {
            this.fCurLocation = null;
        }
    }

    public void setRank(long rank) {
        this.fCurRank = rank;
    }

    public void increaseRank() {
        if (this.hasValidRank()) {
            ++this.fCurRank;
        }
    }

    public CtfTmfTrace getTrace() {
        return this.fTrace;
    }

    public synchronized CtfTmfEvent getCurrentEvent() {
        return this.getIterator().getCurrentEvent();
    }

    public synchronized boolean advance() {
        CtfLocationInfo curLocationData = this.fCurLocation.getLocationInfo();
        CtfIterator iterator = this.getIterator();
        boolean retVal = iterator.advance();
        CtfTmfEvent currentEvent = iterator.getCurrentEvent();
        if (currentEvent != null) {
            long timestampValue = iterator.getCurrentTimestamp();
            this.fCurLocation = curLocationData.getTimestamp() == timestampValue ? new CtfLocation(timestampValue, curLocationData.getIndex() + 1L) : new CtfLocation(timestampValue, 0L);
        } else {
            this.fCurLocation = new CtfLocation(CtfLocation.INVALID_LOCATION);
        }
        return retVal;
    }

    public void dispose() {
        this.fTrace.disposeContext(this);
    }

    public synchronized boolean seek(long timestamp) {
        CtfIterator iterator = this.getIterator();
        boolean ret = iterator.seek(timestamp);
        this.fCurLocation = iterator.getLocation();
        return ret;
    }

    public synchronized boolean seek(CtfLocationInfo location) {
        this.fCurLocation = new CtfLocation(location);
        return this.getIterator().seek(location);
    }

    private CtfIterator getIterator() {
        return (CtfIterator)this.fTrace.createIteratorFromContext(this);
    }
}

