/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.interval;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;

public final class TmfStateInterval
implements ITmfStateInterval {
    private final long start;
    private final long end;
    private final int attribute;
    private final @NonNull ITmfStateValue sv;

    public TmfStateInterval(long start, long end, int attribute, @NonNull ITmfStateValue sv) {
        this.start = start;
        this.end = end;
        this.attribute = attribute;
        this.sv = sv;
    }

    @Override
    public long getStartTime() {
        return this.start;
    }

    @Override
    public long getEndTime() {
        return this.end;
    }

    @Override
    public int getAttribute() {
        return this.attribute;
    }

    @Override
    public ITmfStateValue getStateValue() {
        return this.sv;
    }

    @Override
    public boolean intersects(long timestamp) {
        return this.start <= timestamp && this.end >= timestamp;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("start", this.start).append("end", this.end).append("key", this.attribute).append("value", (Object)this.sv.toString()).toString();
    }
}

