/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.classic;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.IntegerRangeCondition;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.TimeRangeCondition;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTConfig;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTNode;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.ParentNode;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;

public final class CoreNode
extends ParentNode {
    private int nbChildren = 0;
    private int[] children;
    private long[] childStart;
    private volatile int extension = -1;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock(false);

    public CoreNode(HTConfig config, int seqNumber, int parentSeqNumber, long start) {
        super(config, seqNumber, parentSeqNumber, start);
        int size = config.getMaxChildren();
        this.children = new int[size];
        this.childStart = new long[size];
    }

    @Override
    protected void readSpecificHeader(ByteBuffer buffer) {
        int size = this.getConfig().getMaxChildren();
        this.extension = buffer.getInt();
        this.nbChildren = buffer.getInt();
        this.children = new int[size];
        int i = 0;
        while (i < this.nbChildren) {
            this.children[i] = buffer.getInt();
            ++i;
        }
        i = this.nbChildren;
        while (i < size) {
            buffer.getInt();
            ++i;
        }
        this.childStart = new long[size];
        i = 0;
        while (i < this.nbChildren) {
            this.childStart[i] = buffer.getLong();
            ++i;
        }
        i = this.nbChildren;
        while (i < size) {
            buffer.getLong();
            ++i;
        }
    }

    @Override
    protected void writeSpecificHeader(ByteBuffer buffer) {
        int size = this.getConfig().getMaxChildren();
        buffer.putInt(this.extension);
        buffer.putInt(this.nbChildren);
        int i = 0;
        while (i < this.nbChildren) {
            buffer.putInt(this.children[i]);
            ++i;
        }
        i = this.nbChildren;
        while (i < size) {
            buffer.putInt(0);
            ++i;
        }
        i = 0;
        while (i < this.nbChildren) {
            buffer.putLong(this.childStart[i]);
            ++i;
        }
        i = this.nbChildren;
        while (i < size) {
            buffer.putLong(0L);
            ++i;
        }
    }

    @Override
    public int getNbChildren() {
        this.rwl.readLock().lock();
        try {
            int n = this.nbChildren;
            return n;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @Override
    public int getChild(int index) {
        this.rwl.readLock().lock();
        try {
            int n = this.children[index];
            return n;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @Override
    public int getLatestChild() {
        this.rwl.readLock().lock();
        try {
            int n = this.children[this.nbChildren - 1];
            return n;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @Override
    public long getChildStart(int index) {
        this.rwl.readLock().lock();
        try {
            long l = this.childStart[index];
            return l;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    private long getChildEnd(int index) {
        this.rwl.readLock().lock();
        try {
            if (index < this.nbChildren - 1) {
                long l = this.childStart[index + 1] - 1L;
                return l;
            }
            long l = this.isOnDisk() ? this.getNodeEnd() : Long.MAX_VALUE;
            return l;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    public int getExtensionSequenceNumber() {
        this.rwl.readLock().lock();
        try {
            int n = this.extension;
            return n;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @Override
    public void linkNewChild(HTNode childNode) {
        this.rwl.writeLock().lock();
        try {
            if (this.nbChildren >= this.getConfig().getMaxChildren()) {
                throw new IllegalStateException("Asked to link another child but parent already has maximum number of children");
            }
            this.children[this.nbChildren] = childNode.getSequenceNumber();
            this.childStart[this.nbChildren] = childNode.getNodeStart();
            ++this.nbChildren;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @Override
    public Collection<Integer> selectNextChildren(long t) throws TimeRangeException {
        if (t < this.getNodeStart() || this.isOnDisk() && t > this.getNodeEnd()) {
            throw new TimeRangeException("Requesting children outside the node's range: " + t);
        }
        this.rwl.readLock().lock();
        try {
            int potentialNextSeqNb = -1;
            int i = 0;
            while (i < this.nbChildren) {
                if (t < this.childStart[i]) break;
                potentialNextSeqNb = this.children[i];
                ++i;
            }
            if (potentialNextSeqNb == -1) {
                throw new IllegalStateException("No next child node found");
            }
            Set<Integer> set = Collections.singleton(potentialNextSeqNb);
            return set;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @Override
    public Collection<Integer> selectNextChildren2D(IntegerRangeCondition quarks, TimeRangeCondition times) {
        this.rwl.readLock().lock();
        try {
            ArrayList<Integer> list = new ArrayList<Integer>();
            int child = 0;
            while (child < this.nbChildren) {
                if (times.intersects(this.getChildStart(child), this.getChildEnd(child))) {
                    int potentialNextSeqNb = this.getChild(child);
                    list.add(potentialNextSeqNb);
                }
                ++child;
            }
            ArrayList<Integer> arrayList = list;
            return arrayList;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @Override
    public HTNode.NodeType getNodeType() {
        return HTNode.NodeType.CORE;
    }

    @Override
    protected int getSpecificHeaderSize() {
        int maxChildren = this.getConfig().getMaxChildren();
        int specificSize = 8 + 4 * maxChildren + 8 * maxChildren;
        return specificSize;
    }

    @Override
    public String toStringSpecific() {
        return String.format("Core Node, %d children %s", this.nbChildren, Arrays.toString(Arrays.copyOf(this.children, this.nbChildren)));
    }
}

