/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services;

import java.util.Map;
import java.util.Set;
import org.eclipse.sapphire.Disposable;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.util.MapFactory;
import org.eclipse.sapphire.util.SetFactory;

public final class ServiceProxy
implements Disposable {
    private final ServiceContext context;
    private final String id;
    private final Class<? extends Service> implementation;
    private final Class<? extends ServiceCondition> condition;
    private final Set<String> overrides;
    private final Map<String, String> parameters;
    private Service service;

    public ServiceProxy(ServiceContext context, String id, Class<? extends Service> implementation, Class<? extends ServiceCondition> condition, Set<String> overrides, Map<String, String> parameters) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        if (id == null) {
            throw new IllegalArgumentException();
        }
        if (implementation == null) {
            throw new IllegalArgumentException();
        }
        this.context = context;
        this.id = id;
        this.implementation = implementation;
        this.condition = condition;
        this.overrides = overrides == null ? SetFactory.empty() : overrides;
        this.parameters = parameters == null ? MapFactory.empty() : parameters;
    }

    public String id() {
        return this.id;
    }

    public Class<? extends Service> type() {
        return this.implementation;
    }

    public Set<String> overrides() {
        return this.overrides;
    }

    public synchronized Service service() {
        if (this.service == null) {
            boolean applicable;
            if (this.condition == null) {
                applicable = true;
            } else {
                applicable = false;
                try {
                    ServiceCondition c = this.condition.newInstance();
                    applicable = c.applicable(this.context);
                }
                catch (Exception e) {
                    Sapphire.service(LoggingService.class).log(e);
                }
            }
            if (applicable) {
                try {
                    Service instance = this.implementation.newInstance();
                    instance.init(this.context, this.id, this.parameters, this.overrides);
                    this.service = instance;
                }
                catch (Exception e) {
                    Sapphire.service(LoggingService.class).log(e);
                }
            }
        }
        return this.service;
    }

    @Override
    public void dispose() {
        if (this.service != null) {
            try {
                this.service.dispose();
            }
            catch (Exception e) {
                Sapphire.service(LoggingService.class).log(e);
            }
        }
    }
}

