/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.sapphire.Disposable;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ListenerContext;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceEvent;
import org.eclipse.sapphire.util.MapFactory;
import org.eclipse.sapphire.util.SetFactory;

public abstract class Service
implements Disposable {
    private boolean initialized;
    private ServiceContext context;
    private String id;
    private Map<String, String> params;
    private Set<String> overrides;
    private ListenerContext listeners;

    final void init(ServiceContext context, String id, Map<String, String> params, Set<String> overrides) {
        this.context = context;
        this.id = id;
        this.params = MapFactory.unmodifiable(params);
        this.overrides = SetFactory.unmodifiable(overrides);
        this.listeners = new ListenerContext(context.queue());
    }

    final void initIfNecessary() {
        if (!this.initialized) {
            this.initialized = true;
            try {
                this.init();
            }
            catch (Exception e) {
                Sapphire.service(LoggingService.class).log(e);
            }
        }
    }

    protected void init() {
    }

    public final ServiceContext context() {
        return this.context;
    }

    public final <T> T context(Class<T> type) {
        return this.context.find(type);
    }

    protected final <S extends Service> S service(Class<S> serviceType) {
        return this.context.service(serviceType);
    }

    protected final <S extends Service> List<S> services(Class<S> serviceType) {
        return this.context.services(serviceType);
    }

    final String id() {
        return this.id;
    }

    protected final Map<String, String> params() {
        return this.params;
    }

    protected final String param(String name) {
        return this.params.get(name);
    }

    final Set<String> overrides() {
        return this.overrides;
    }

    public final boolean attach(Listener listener) {
        return this.listeners.attach(listener);
    }

    public final boolean detach(Listener listener) {
        return this.listeners.detach(listener);
    }

    protected final void broadcast(Event event) {
        this.listeners.broadcast(event);
    }

    protected final void broadcast() {
        this.broadcast(new ServiceEvent(this));
    }

    @Override
    public void dispose() {
    }
}

