/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.PreferDefaultValue;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.internal.ValueSnapshot;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ValidationService;

public final class PreferDefaultValueValidationService
extends ValidationService {
    @Text(value="{0} should be {1}")
    private static LocalizableText message;
    private Listener listener;

    static {
        LocalizableText.init(PreferDefaultValueValidationService.class);
    }

    @Override
    protected void initValidationService() {
        this.listener = new FilteredListener<PropertyContentEvent>(){

            @Override
            protected void handleTypedEvent(PropertyContentEvent event) {
                PreferDefaultValueValidationService.this.refresh();
            }
        };
        this.context(Property.class).attach(this.listener);
    }

    @Override
    protected Status compute() {
        Value value = this.context(Value.class);
        if (!value.empty()) {
            String text = value.text();
            String def = value.getDefaultText();
            if (def != null && !def.equals(text)) {
                ValueProperty p = value.definition();
                String msg = message.format(p.getLabel(true, CapitalizationType.FIRST_WORD_ONLY, false), new ValueSnapshot(p, def));
                return Status.createWarningStatus(msg);
            }
        }
        return Status.createOkStatus();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.listener != null) {
            this.context(Property.class).detach(this.listener);
        }
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            ValueProperty property = context.find(ValueProperty.class);
            if (property != null) {
                return property.hasAnnotation(PreferDefaultValue.class);
            }
            return false;
        }
    }
}

