/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import java.util.Set;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementReferenceService;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PossibleValuesService;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class ElementReferencePossibleValuesService
extends PossibleValuesService {
    public ElementReferenceService elementReferenceService;
    public Listener elementReferenceServiceListener;
    public ElementList<?> list;
    public String key;
    public Listener listListener;

    @Override
    protected void initPossibleValuesService() {
        this.elementReferenceService = this.context(ReferenceValue.class).service(ElementReferenceService.class);
        this.elementReferenceServiceListener = new FilteredListener<ElementReferenceService.SourceEvent>(){

            @Override
            protected void handleTypedEvent(ElementReferenceService.SourceEvent event) {
                ElementReferencePossibleValuesService.this.refresh();
            }
        };
        this.elementReferenceService.attach(this.elementReferenceServiceListener);
        this.listListener = new FilteredListener<PropertyContentEvent>(){

            @Override
            protected void handleTypedEvent(PropertyContentEvent event) {
                ElementReferencePossibleValuesService.this.refresh();
            }
        };
    }

    @Override
    protected void compute(Set<String> values) {
        ElementList<?> list = this.elementReferenceService.list();
        String key = this.elementReferenceService.key();
        if (this.list != list || !MiscUtil.equal(this.key, key)) {
            if (this.list != null) {
                this.list.detach(this.listListener, this.key);
                this.list = null;
            }
            this.list = list;
            this.key = key;
            if (this.list != null) {
                this.list.attach(this.listListener, this.key);
            }
        }
        if (this.list != null) {
            for (Element element : this.list) {
                String text = ((Value)element.property(this.key)).text();
                if (text == null) continue;
                values.add(text);
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.elementReferenceService.detach(this.elementReferenceServiceListener);
        this.elementReferenceService = null;
        this.elementReferenceServiceListener = null;
        if (this.list != null) {
            if (!this.list.disposed()) {
                this.list.detach(this.listListener, this.key);
            }
            this.list = null;
        }
        this.key = null;
        this.listListener = null;
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            ReferenceValue ref = context.find(ReferenceValue.class);
            return ref != null && ref.service(ElementReferenceService.class) != null;
        }
    }
}

