/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.sapphire.Disposable;
import org.eclipse.sapphire.EventDeliveryJob;
import org.eclipse.sapphire.JobQueue;
import org.eclipse.sapphire.modeling.internal.SapphireModelingExtensionSystem;
import org.eclipse.sapphire.modeling.util.DependencySorter;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceProxy;
import org.eclipse.sapphire.util.ListFactory;

public class ServiceContext
implements Disposable {
    public static final String ID_ROOT = "Sapphire";
    public static final String ID_ELEMENT_INSTANCE = "Sapphire.Element.Instance";
    public static final String ID_ELEMENT_METAMODEL = "Sapphire.Element.MetaModel";
    public static final String ID_PROPERTY_INSTANCE = "Sapphire.Property.Instance";
    public static final String ID_PROPERTY_METAMODEL = "Sapphire.Property.MetaModel";
    private final String type;
    private final ServiceContext parent;
    private List<ServiceProxy> services;
    private Map<Class<?>, List<? extends Service>> cache;
    private final JobQueue<EventDeliveryJob> queue;
    private final Object lock;
    private boolean disposed = false;

    public ServiceContext(String type) {
        this(type, null, null, null);
    }

    public ServiceContext(String type, ServiceContext parent) {
        this(type, parent, null, null);
    }

    public ServiceContext(String type, ServiceContext parent, Object lock, JobQueue<EventDeliveryJob> queue) {
        this.type = type;
        this.parent = parent;
        this.lock = lock == null ? this : lock;
        this.queue = queue == null ? new JobQueue() : queue;
    }

    public final String type() {
        return this.type;
    }

    public final ServiceContext parent() {
        return this.parent;
    }

    public <T> T find(Class<T> type) {
        return null;
    }

    public final <S extends Service> S service(Class<S> type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (this.disposed) {
            throw new IllegalStateException();
        }
        List<S> services = this.services(type);
        return (S)(services.isEmpty() ? null : (Service)services.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <S extends Service> List<S> services(Class<S> type) {
        Object object = this.lock;
        synchronized (object) {
            Object services;
            if (type == null) {
                throw new IllegalArgumentException();
            }
            if (this.disposed) {
                throw new IllegalStateException();
            }
            if (this.cache != null && (services = this.cache.get(type)) != null) {
                return services;
            }
            if (this.services == null) {
                services = ListFactory.start();
                ((ListFactory)services).add(this.local());
                for (SapphireModelingExtensionSystem.ServiceExtension extension : SapphireModelingExtensionSystem.services()) {
                    if (!extension.contexts().contains(this.type)) continue;
                    ((ListFactory)services).add(new ServiceProxy(this, extension.id(), extension.implementation(), extension.condition(), extension.overrides(), null));
                }
                this.services = new CopyOnWriteArrayList<ServiceProxy>(((ListFactory)services).result());
            }
            DependencySorter<String, Service> sorter = new DependencySorter<String, Service>();
            ListFactory<ServiceProxy> failed = ListFactory.start();
            for (ServiceProxy proxy : this.services) {
                if (!type.isAssignableFrom(proxy.type())) continue;
                if (sorter.contains(proxy.id())) {
                    failed.add(proxy);
                    continue;
                }
                Service service = (Service)type.cast(proxy.service());
                if (service == null) {
                    failed.add(proxy);
                    continue;
                }
                sorter.add(service.id(), service);
                for (String override : service.overrides()) {
                    sorter.dependency(override, service.id());
                }
            }
            this.services.removeAll(failed.result());
            if (this.parent != null) {
                for (Service service : this.parent.services(type)) {
                    if (sorter.contains(service.id())) continue;
                    sorter.add(service.id(), service);
                    for (String override : service.overrides()) {
                        sorter.dependency(override, service.id());
                    }
                }
            }
            List services2 = sorter.sort();
            for (Service service : services2) {
                service.initIfNecessary();
            }
            if (this.cache == null) {
                this.cache = new IdentityHashMap();
            }
            this.cache.put(type, services2);
            return services2;
        }
    }

    public final Object lock() {
        return this.lock;
    }

    final JobQueue<EventDeliveryJob> queue() {
        return this.queue;
    }

    protected List<ServiceProxy> local() {
        return Collections.emptyList();
    }

    @Override
    public final void dispose() {
        this.disposed = true;
        for (ServiceProxy service : this.services) {
            service.dispose();
        }
        this.services = null;
    }
}

