/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.parser;

import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.php.core.compiler.ast.nodes.FullyQualifiedReference;
import org.eclipse.php.core.compiler.ast.nodes.NamespaceReference;
import org.eclipse.php.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.core.compiler.ast.nodes.UseStatement;
import org.eclipse.php.internal.core.compiler.ast.parser.AbstractUseStatementASTVisitor;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;

public class FindUseStatementByNamespaceASTVisitor
extends AbstractUseStatementASTVisitor {
    private UseStatement currentUseStatement;
    private String namespace;
    private UsePart result;

    @Override
    protected void visit(UseStatement s) throws Exception {
        this.currentUseStatement = s;
        super.visit(s);
    }

    public boolean endvisit(Statement s) throws Exception {
        if (s instanceof UseStatement) {
            this.currentUseStatement = null;
        }
        return super.endvisit(s);
    }

    public FindUseStatementByNamespaceASTVisitor(String namespace, int offset) {
        super(offset);
        this.namespace = namespace;
    }

    public UsePart getResult() {
        return this.result;
    }

    @Override
    protected boolean visit(UsePart usePart) {
        boolean isGroupStatement;
        String ns = usePart.getNamespace().getFullyQualifiedName();
        boolean bl = isGroupStatement = this.currentUseStatement != null && this.currentUseStatement.getNamespace() != null;
        if (isGroupStatement) {
            String curentFQN = this.currentUseStatement.getNamespace().getFullyQualifiedName();
            ns = PHPModelUtils.concatFullyQualifiedNames(curentFQN, ns);
        }
        if (this.namespace.equalsIgnoreCase(ns)) {
            if (isGroupStatement) {
                FullyQualifiedReference fqn = this.createCombinedFQN(usePart);
                this.result = new UsePart(fqn, usePart.getAlias(), Math.max(this.currentUseStatement.getStatementType(), usePart.getStatementType()));
            } else {
                this.result = usePart;
            }
            return false;
        }
        return true;
    }

    private FullyQualifiedReference createCombinedFQN(UsePart usePart) {
        String firstNamespace = this.currentUseStatement.getNamespace().getFullyQualifiedName();
        String name = PHPModelUtils.extractElementName(usePart.getNamespace().getFullyQualifiedName());
        String secondNamespace = PHPModelUtils.extractNameSpaceName(usePart.getNamespace().getFullyQualifiedName());
        String fqn = PHPModelUtils.concatFullyQualifiedNames(firstNamespace, secondNamespace);
        return new FullyQualifiedReference(0, 0, name, new NamespaceReference(0, 0, fqn));
    }
}

