/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.parser;

import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.php.core.compiler.ast.nodes.FullyQualifiedReference;
import org.eclipse.php.core.compiler.ast.nodes.NamespaceReference;
import org.eclipse.php.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.core.compiler.ast.nodes.UseStatement;
import org.eclipse.php.internal.core.compiler.ast.parser.AbstractUseStatementASTVisitor;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;

public class FindUseStatementByAliasASTVisitor
extends AbstractUseStatementASTVisitor {
    private UseStatement currentUseStatement;
    private String aliasName;
    private UsePart result;

    public FindUseStatementByAliasASTVisitor(String aliasName, int offset) {
        super(offset);
        this.aliasName = aliasName;
    }

    public UsePart getResult() {
        return this.result;
    }

    @Override
    protected void visit(UseStatement s) throws Exception {
        this.currentUseStatement = s;
        super.visit(s);
    }

    public boolean endvisit(Statement s) throws Exception {
        if (s instanceof UseStatement) {
            this.currentUseStatement = null;
        }
        return super.endvisit(s);
    }

    @Override
    protected boolean visit(UsePart usePart) {
        String alias = usePart.getAlias() != null ? usePart.getAlias().getName() : usePart.getNamespace().getName();
        if (this.aliasName.equalsIgnoreCase(alias)) {
            if (this.currentUseStatement == null || this.currentUseStatement.getNamespace() == null) {
                this.result = usePart;
            } else {
                FullyQualifiedReference fqn = this.createCombinedFQN(usePart);
                this.result = new UsePart(fqn, usePart.getAlias(), Math.max(this.currentUseStatement.getStatementType(), usePart.getStatementType()));
            }
            return false;
        }
        return true;
    }

    private FullyQualifiedReference createCombinedFQN(UsePart usePart) {
        String firstNamespace = this.currentUseStatement.getNamespace().getFullyQualifiedName();
        String name = PHPModelUtils.extractElementName(usePart.getNamespace().getFullyQualifiedName());
        String secondNamespace = PHPModelUtils.extractNameSpaceName(usePart.getNamespace().getFullyQualifiedName());
        String fqn = PHPModelUtils.concatFullyQualifiedNames(firstNamespace, secondNamespace);
        return new FullyQualifiedReference(0, 0, name, new NamespaceReference(0, 0, fqn));
    }
}

