/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.contexts;

import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;

public class IncludeStatementContext
extends AbstractCompletionContext {
    private int variantLength = 0;

    @Override
    public boolean isValid(ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        if (!super.isValid(sourceModule, offset, requestor)) {
            return false;
        }
        TextSequence statementText = this.getStatementText();
        return this.isIncludeStatement(statementText);
    }

    private final boolean isIncludeStatement(TextSequence statementText, String variant) {
        if (statementText.length() <= variant.length()) {
            return false;
        }
        int length = variant.length();
        if (variant.equalsIgnoreCase(statementText.subSequence(0, length).toString()) && Character.isWhitespace(statementText.subSequence(length, length + 1).charAt(0))) {
            this.variantLength = variant.length();
            return true;
        }
        return false;
    }

    private final boolean isIncludeStatement(TextSequence statementText) {
        return this.isIncludeStatement(statementText, "require_once") || this.isIncludeStatement(statementText, "require") || this.isIncludeStatement(statementText, "include_once") || this.isIncludeStatement(statementText, "include");
    }

    @Override
    public boolean isExclusive() {
        return true;
    }

    @Override
    public String getPrefix() throws BadLocationException {
        if (this.hasWhitespaceBeforeCursor()) {
            return "";
        }
        TextSequence statementText = this.getStatementText();
        int prefixEnd = statementText.length();
        if (prefixEnd <= this.variantLength) {
            return super.getPrefix();
        }
        TextSequence cutTextSequence = statementText.cutTextSequence(0, this.variantLength);
        int prefixStart = PHPTextSequenceUtilities.readForwardUntilDelim(cutTextSequence, 0, new char[]{'\'', '\"'});
        int i = this.variantLength + prefixStart + 1;
        if (i <= prefixEnd) {
            return statementText.subSequence(i, prefixEnd).toString();
        }
        return super.getPrefix();
    }
}

