/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.contexts;

import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractGlobalStatementContext;

public class GlobalMethodStatementContext
extends AbstractGlobalStatementContext {
    private IMethod enclosingMethod;
    private IType enclosingType;

    @Override
    public boolean isValid(ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        IModelElement enclosingElement;
        block9: {
            if (!super.isValid(sourceModule, offset, requestor)) {
                return false;
            }
            enclosingElement = this.getEnclosingElement();
            while (enclosingElement instanceof IField) {
                enclosingElement = enclosingElement.getParent();
            }
            if (!(enclosingElement instanceof IMethod)) {
                return false;
            }
            if (!this.isBeforeName(offset, (ISourceReference)((IMethod)enclosingElement))) break block9;
            return false;
        }
        try {
            this.enclosingMethod = (IMethod)enclosingElement;
            while (enclosingElement != null) {
                if (enclosingElement instanceof ISourceModule) break;
                if (enclosingElement instanceof IType) {
                    if (PHPFlags.isNamespace(((IType)enclosingElement).getFlags())) break;
                    this.enclosingType = (IType)enclosingElement;
                }
                enclosingElement = enclosingElement.getParent();
            }
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
            return false;
        }
        return true;
    }

    public IMethod getEnclosingMethod() {
        return this.enclosingMethod;
    }

    public IType getEnclosingType() {
        return this.enclosingType;
    }
}

