/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.compiler.problem.DefaultProblem;
import org.eclipse.dltk.compiler.problem.DefaultProblemIdentifier;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Comment;
import org.eclipse.php.core.ast.nodes.DefaultCommentMapper;
import org.eclipse.php.core.ast.nodes.IBinding;
import org.eclipse.php.core.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.core.ast.nodes.Statement;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.UseStatement;
import org.eclipse.php.core.ast.visitor.ApplyAll;
import org.eclipse.php.core.ast.visitor.Visitor;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.ast.locator.Locator;
import org.eclipse.php.internal.core.ast.scanner.AstLexer;
import org.eclipse.text.edits.TextEdit;

public class Program
extends ASTNode {
    private final ASTNode.NodeList<Statement> statements = new ASTNode.NodeList(STATEMENTS_PROPERTY);
    private final ASTNode.NodeList<Comment> comments = new ASTNode.NodeList(COMMENTS_PROPERTY);
    private Map<NamespaceDeclaration, List<UseStatement>> fUseStatements;
    private List<NamespaceDeclaration> fNamespaceDeclarations;
    public static final ChildListPropertyDescriptor STATEMENTS_PROPERTY = new ChildListPropertyDescriptor(Program.class, "statements", Statement.class, false);
    public static final ChildListPropertyDescriptor COMMENTS_PROPERTY = new ChildListPropertyDescriptor(Program.class, "comments", Comment.class, false);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;
    private DefaultCommentMapper commentMapper = null;
    private ISourceModule sourceModule = null;
    private int[] lineEndTable = new int[0];

    static {
        ArrayList<ChildListPropertyDescriptor> properyList = new ArrayList<ChildListPropertyDescriptor>(1);
        properyList.add(STATEMENTS_PROPERTY);
        properyList.add(COMMENTS_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(properyList);
    }

    public Program(int start, int end, AST ast, List<Statement> statements, List<Comment> commentList) {
        super(start, end, ast);
        if (statements == null || this.comments == null) {
            throw new IllegalArgumentException();
        }
        this.statements.addAll(statements);
        this.comments.addAll(commentList);
    }

    public Program(AST ast) {
        super(ast);
    }

    public List<Comment> comments() {
        return this.comments;
    }

    public void setSourceModule(ISourceModule typeRoot) {
        this.sourceModule = typeRoot;
    }

    public ISourceModule getSourceModule() {
        return this.sourceModule;
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        for (ASTNode aSTNode : this.statements) {
            aSTNode.accept(visitor);
        }
        for (ASTNode aSTNode : this.comments) {
            aSTNode.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        for (ASTNode aSTNode : this.statements) {
            aSTNode.traverseTopDown(visitor);
        }
        for (ASTNode aSTNode : this.comments) {
            aSTNode.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        for (ASTNode aSTNode : this.statements) {
            aSTNode.traverseBottomUp(visitor);
        }
        for (ASTNode aSTNode : this.comments) {
            aSTNode.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append("<Program");
        this.appendInterval(buffer);
        buffer.append(">\n").append("\t").append("<Statements>\n");
        for (ASTNode aSTNode : this.statements) {
            aSTNode.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append("</Statements>\n").append("\t").append("<Comments>\n");
        for (ASTNode aSTNode : this.comments) {
            aSTNode.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append("</Comments>\n").append("</Program>");
    }

    @Override
    public int getType() {
        return 46;
    }

    public List<Statement> statements() {
        return this.statements;
    }

    public ASTNode getElementAt(int offset) {
        return Locator.locateNode(this, offset);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    public void initCommentMapper(IDocument document, AstLexer scanner) {
        this.commentMapper = new DefaultCommentMapper(this.comments().toArray(new Comment[this.comments().size()]));
        this.commentMapper.initialize(this, scanner, document);
    }

    DefaultCommentMapper getCommentMapper() {
        return this.commentMapper;
    }

    public void setLineEndTable(int[] lineEndTable) {
        if (lineEndTable == null) {
            throw new NullPointerException();
        }
        this.lineEndTable = lineEndTable;
    }

    public int getColumnNumber(int position) {
        int currentLineEnd;
        if (this.lineEndTable == null) {
            return -2;
        }
        int line = this.getLineNumber(position);
        if (line == -1) {
            return -1;
        }
        if (line == 1) {
            if (position >= this.getStart() + this.getLength()) {
                return -1;
            }
            return position;
        }
        int length = this.lineEndTable.length;
        int previousLineOffset = this.lineEndTable[line - 2];
        int offsetForLine = previousLineOffset + 1;
        int n = currentLineEnd = line == length + 1 ? this.getStart() + this.getLength() - 1 : this.lineEndTable[line - 1];
        if (offsetForLine > currentLineEnd) {
            return -1;
        }
        return position - offsetForLine;
    }

    public int getLineNumber(int position) {
        if (this.lineEndTable == null) {
            return -2;
        }
        int length = this.lineEndTable.length;
        if (length == 0) {
            if (position >= this.getStart() + this.getLength()) {
                return -1;
            }
            return 1;
        }
        int low = 0;
        if (position < 0) {
            return -1;
        }
        if (position <= this.lineEndTable[low]) {
            return 1;
        }
        int hi = length - 1;
        if (position > this.lineEndTable[hi]) {
            if (position >= this.getStart() + this.getLength()) {
                return -1;
            }
            return length + 1;
        }
        while (low + 1 != hi) {
            int mid = low + (hi - low) / 2;
            if (position <= this.lineEndTable[mid]) {
                hi = mid;
                continue;
            }
            low = mid;
        }
        return low + 2;
    }

    public int getPosition(int line, int column) {
        int currentLineEnd;
        if (this.lineEndTable == null) {
            return -2;
        }
        if (line < 1 || column < 0) {
            return -1;
        }
        int length = this.lineEndTable.length;
        if (length == 0) {
            if (line != 1) {
                return -1;
            }
            return column >= this.getStart() + this.getLength() ? -1 : column;
        }
        if (line == 1) {
            int endOfLine = this.lineEndTable[0];
            return column > endOfLine ? -1 : column;
        }
        if (line > length + 1) {
            return -1;
        }
        int previousLineOffset = this.lineEndTable[line - 2];
        int offsetForLine = previousLineOffset + 1;
        int n = currentLineEnd = line == length + 1 ? this.getStart() + this.getLength() - 1 : this.lineEndTable[line - 1];
        if (offsetForLine + column > currentLineEnd) {
            return -1;
        }
        return offsetForLine + column;
    }

    public int getExtendedLength(ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        if (this.commentMapper == null || node.getAST() != this.getAST()) {
            return node.getLength();
        }
        return this.commentMapper.getExtendedLength(node);
    }

    public int getExtendedStartPosition(ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        if (this.commentMapper == null || node.getAST() != this.getAST()) {
            return node.getStart();
        }
        return this.commentMapper.getExtendedStartPosition(node);
    }

    public int firstLeadingCommentIndex(ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        if (this.commentMapper == null || node.getAST() != this.getAST()) {
            return -1;
        }
        return this.commentMapper.firstLeadingCommentIndex(node);
    }

    public int lastTrailingCommentIndex(ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        if (this.commentMapper == null || node.getAST() != this.getAST()) {
            return -1;
        }
        return this.commentMapper.lastTrailingCommentIndex(node);
    }

    public void recordModifications() {
        this.getAST().recordModifications(this);
    }

    public TextEdit rewrite(IDocument document, Map options) {
        return this.getAST().rewrite(document, options);
    }

    @Override
    ASTNode clone0(AST target) {
        List<Statement> statements = ASTNode.copySubtrees(target, this.statements());
        List<Comment> comments = ASTNode.copySubtrees(target, this.comments());
        return new Program(this.getStart(), this.getEnd(), target, statements, comments);
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == STATEMENTS_PROPERTY) {
            return this.statements();
        }
        if (property == COMMENTS_PROPERTY) {
            return this.comments();
        }
        return super.internalGetChildListProperty(property);
    }

    public ASTNode findDeclaringNode(IBinding binding) {
        ISourceReference phpElement = (ISourceReference)binding.getPHPElement();
        try {
            return this.getElementAt(phpElement.getSourceRange().getOffset());
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
            return null;
        }
    }

    public IProblem[] getProblems() {
        try {
            if (this.getSourceModule() == null) {
                return new IProblem[0];
            }
            IResource resource = this.getSourceModule().getUnderlyingResource();
            if (resource != null) {
                IMarker[] markers = resource.findMarkers("org.eclipse.php.core.phpproblemmarker", true, 1);
                DefaultProblem[] problems = new DefaultProblem[markers.length];
                int i = 0;
                while (i < markers.length) {
                    IProblemIdentifier id = DefaultProblemIdentifier.decode((String)markers[i].getAttribute("id", ""));
                    String message = markers[i].getAttribute("message", "");
                    int start = markers[i].getAttribute("charStart", 0);
                    int end = markers[i].getAttribute("charEnd", 0);
                    int line = markers[i].getAttribute("lineNumber", 0);
                    problems[i] = new DefaultProblem(resource.getName(), message, id, null, null, start, end, line, 0);
                    ++i;
                }
                return problems;
            }
        }
        catch (CoreException coreException) {}
        return new IProblem[0];
    }

    public Map<NamespaceDeclaration, List<UseStatement>> getUseStatements() {
        if (this.fUseStatements == null) {
            this.fUseStatements = new HashMap<NamespaceDeclaration, List<UseStatement>>();
            List<NamespaceDeclaration> namespaceDeclarations = this.getNamespaceDeclarations();
            if (namespaceDeclarations.size() == 0) {
                UseStatementFinder visitor = new UseStatementFinder();
                this.accept(visitor);
                this.fUseStatements.put(null, visitor.getUseStatements());
            } else {
                for (NamespaceDeclaration namespace : namespaceDeclarations) {
                    UseStatementFinder visitor = new UseStatementFinder();
                    namespace.accept(visitor);
                    this.fUseStatements.put(namespace, visitor.getUseStatements());
                }
            }
        }
        return this.fUseStatements;
    }

    public List<UseStatement> getUseStatements(NamespaceDeclaration namespace) {
        if (this.fUseStatements == null) {
            this.getUseStatements();
        }
        return this.fUseStatements.get(namespace);
    }

    public NamespaceDeclaration getNamespaceDeclaration(int position) {
        List<NamespaceDeclaration> namespaceDeclarations = this.getNamespaceDeclarations();
        for (NamespaceDeclaration namespace : namespaceDeclarations) {
            if (namespace.getStart() > position || namespace.getEnd() < position) continue;
            return namespace;
        }
        return null;
    }

    public List<NamespaceDeclaration> getNamespaceDeclarations() {
        if (this.fNamespaceDeclarations == null) {
            NamespaceFinder finder = new NamespaceFinder();
            this.accept(finder);
            this.fNamespaceDeclarations = finder.getAllNamespaces();
        }
        return this.fNamespaceDeclarations;
    }

    private class NamespaceFinder
    extends ApplyAll {
        private List<NamespaceDeclaration> allNamespaces = new ArrayList<NamespaceDeclaration>();

        private NamespaceFinder() {
        }

        @Override
        protected boolean apply(ASTNode node) {
            if (node instanceof NamespaceDeclaration) {
                this.allNamespaces.add((NamespaceDeclaration)node);
                return false;
            }
            return true;
        }

        public List<NamespaceDeclaration> getAllNamespaces() {
            return this.allNamespaces;
        }
    }

    private class UseStatementFinder
    extends ApplyAll {
        private List<UseStatement> useStatements = new ArrayList<UseStatement>();

        private UseStatementFinder() {
        }

        @Override
        protected boolean apply(ASTNode node) {
            if (node instanceof UseStatement) {
                this.useStatements.add((UseStatement)node);
                return false;
            }
            return true;
        }

        public List<UseStatement> getUseStatements() {
            return this.useStatements;
        }
    }
}

