/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.IdentityCommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.service.types.command.MessageAbstractReorientCommand;
import org.eclipse.papyrus.uml.service.types.command.MessageAsyncReorientCommand;
import org.eclipse.papyrus.uml.service.types.command.MessageDeleteReorientCommand;
import org.eclipse.papyrus.uml.service.types.command.MessageFoundReorientCommand;
import org.eclipse.papyrus.uml.service.types.command.MessageLostReorientCommand;
import org.eclipse.papyrus.uml.service.types.command.MessageReplyReorientCommand;
import org.eclipse.papyrus.uml.service.types.command.MessageSyncReorientCommand;
import org.eclipse.papyrus.uml.service.types.helper.ElementEditHelper;
import org.eclipse.papyrus.uml.service.types.utils.MessageUtils;
import org.eclipse.papyrus.uml.tools.utils.ExecutionSpecificationUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageKind;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.UMLPackage;

public class MessageEditHelper
extends ElementEditHelper {
    protected ICommand getCreateRelationshipCommand(CreateRelationshipRequest request) {
        boolean noSourceAndTarget;
        EObject source = request.getSource();
        EObject target = request.getTarget();
        boolean noSourceOrTarget = source == null || target == null;
        boolean bl = noSourceAndTarget = source == null && target == null;
        if (!noSourceAndTarget && !this.canCreate(source, target)) {
            return UnexecutableCommand.INSTANCE;
        }
        if (noSourceOrTarget && !noSourceAndTarget) {
            return IdentityCommand.INSTANCE;
        }
        IElementType elementType = request.getElementType();
        EObject owner = request.getContainer();
        return super.getCreateRelationshipCommand(request);
    }

    private boolean canCreate(EObject source, EObject target) {
        return true;
    }

    protected boolean isReadOnly(EObject eObject) {
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)eObject);
        boolean isReadOnly = eObject.eResource() != null && editingDomain.isReadOnly(eObject.eResource());
        return isReadOnly;
    }

    public void configureRequest(IEditCommandRequest request) {
        if (request instanceof CreateRelationshipRequest) {
            Interaction targetInteraction;
            Interaction sourceInteraction;
            CreateRelationshipRequest createRequest = (CreateRelationshipRequest)request;
            EObject source = createRequest.getSource();
            EObject target = createRequest.getTarget();
            if (createRequest.getContainer() == null || !createRequest.getContainer().eClass().getEAllReferences().contains((Object)createRequest.getContainmentFeature()) || createRequest.getContainmentFeature() == null) {
                EObject targetPackage;
                EObject sourcePackage;
                EObject proposedContainer = EMFCoreUtil.getLeastCommonContainer(Arrays.asList(source, target), (EClass)UMLPackage.eINSTANCE.getPackage());
                if (proposedContainer == null && !this.isReadOnly(sourcePackage = EMFCoreUtil.getContainer((EObject)source, (EClass)UMLPackage.eINSTANCE.getInteraction()))) {
                    proposedContainer = sourcePackage;
                }
                if (proposedContainer == null && !this.isReadOnly(targetPackage = EMFCoreUtil.getContainer((EObject)target, (EClass)UMLPackage.eINSTANCE.getInteraction()))) {
                    proposedContainer = targetPackage;
                }
                createRequest.setContainer(proposedContainer);
            }
            if (source instanceof InteractionFragment && target instanceof InteractionFragment && (sourceInteraction = MessageUtils.getContaining(source, Interaction.class)) == (targetInteraction = MessageUtils.getContaining(target, Interaction.class)) && sourceInteraction != null) {
                createRequest.setContainer((EObject)sourceInteraction);
                createRequest.setContainmentFeature(UMLPackage.eINSTANCE.getInteraction_Message());
            }
        }
        super.configureRequest(request);
    }

    protected ICommand getReorientRelationshipCommand(ReorientRelationshipRequest req) {
        MessageAbstractReorientCommand reorientCommand = null;
        Message msgToReorient = (Message)req.getRelationship();
        if (msgToReorient.getMessageKind() == MessageKind.LOST_LITERAL) {
            reorientCommand = new MessageLostReorientCommand(req);
        } else if (msgToReorient.getMessageKind() == MessageKind.FOUND_LITERAL) {
            reorientCommand = new MessageFoundReorientCommand(req);
        } else if (msgToReorient.getMessageSort() == MessageSort.SYNCH_CALL_LITERAL) {
            reorientCommand = new MessageSyncReorientCommand(req);
        } else if (msgToReorient.getMessageSort() == MessageSort.ASYNCH_CALL_LITERAL) {
            reorientCommand = new MessageAsyncReorientCommand(req);
        } else if (msgToReorient.getMessageSort() == MessageSort.ASYNCH_SIGNAL_LITERAL) {
            reorientCommand = new MessageAsyncReorientCommand(req);
        } else if (msgToReorient.getMessageSort() == MessageSort.REPLY_LITERAL) {
            reorientCommand = new MessageReplyReorientCommand(req);
        } else if (msgToReorient.getMessageSort() == MessageSort.CREATE_MESSAGE_LITERAL) {
            reorientCommand = UnexecutableCommand.INSTANCE;
        } else if (msgToReorient.getMessageSort() == MessageSort.DELETE_MESSAGE_LITERAL) {
            if (req.getDirection() == 1) {
                reorientCommand = new MessageDeleteReorientCommand(req);
            } else if (req.getDirection() == 2) {
                reorientCommand = UnexecutableCommand.INSTANCE;
            }
        }
        ICommand updateMessageEndCommand = null;
        MessageEnd msgEndToUpdate = null;
        if (req.getDirection() == 1) {
            msgEndToUpdate = msgToReorient.getSendEvent();
        } else if (req.getDirection() == 2) {
            msgEndToUpdate = msgToReorient.getReceiveEvent();
        }
        updateMessageEndCommand = this.getUpdateMessageEndCommand(msgEndToUpdate, (Element)req.getOldRelationshipEnd(), (Element)req.getNewRelationshipEnd());
        reorientCommand = CompositeCommand.compose((ICommand)reorientCommand, (ICommand)updateMessageEndCommand);
        return reorientCommand.reduce();
    }

    private ICommand getUpdateMessageEndCommand(MessageEnd messageEnd, Element oldElement, Element newElement) {
        ICommand updateCommand = null;
        if (messageEnd instanceof MessageOccurrenceSpecification) {
            updateCommand = this.getUpdateMessageOccurenceSpecificationCommand((MessageOccurrenceSpecification)messageEnd, oldElement, newElement);
        } else if (messageEnd instanceof Gate) {
            updateCommand = this.getUpdateGateCommand((Gate)messageEnd, oldElement, newElement);
        }
        return updateCommand;
    }

    private ICommand getUpdateMessageOccurenceSpecificationCommand(MessageOccurrenceSpecification messageEnd, Element oldElement, Element newElement) {
        Lifeline lifeline;
        ICommand updateCommand = null;
        if (newElement instanceof Lifeline) {
            updateCommand = this.getUpdateOccurenceSpecificationCommand((OccurrenceSpecification)messageEnd, (Lifeline)newElement);
        } else if (newElement instanceof ExecutionSpecification && (lifeline = ExecutionSpecificationUtil.getExecutionSpecificationLifeline((ExecutionSpecification)((ExecutionSpecification)newElement))) != null) {
            updateCommand = this.getUpdateOccurenceSpecificationCommand((OccurrenceSpecification)messageEnd, lifeline);
        }
        return updateCommand;
    }

    private ICommand getUpdateOccurenceSpecificationCommand(OccurrenceSpecification os, Lifeline newLifeline) {
        ICommand updateCommand = null;
        ArrayList<Lifeline> covereds = new ArrayList<Lifeline>();
        covereds.add(newLifeline);
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)os);
        if (provider != null) {
            SetRequest setCoveredRequest = new SetRequest((EObject)os, (EStructuralFeature)UMLPackage.eINSTANCE.getInteractionFragment_Covered(), covereds);
            updateCommand = provider.getEditCommand((IEditCommandRequest)setCoveredRequest);
        }
        return updateCommand;
    }

    private ICommand getUpdateGateCommand(Gate gate, Element oldElement, Element newElement) {
        return null;
    }
}

