/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.drafter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.uml.profile.drafter.IProfileCatalog;
import org.eclipse.papyrus.uml.profile.drafter.ProfileFunctions;
import org.eclipse.papyrus.uml.profile.drafter.exceptions.NotFoundException;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

public class ProfileCatalog
implements IProfileCatalog {
    protected Element namedElement;

    public ProfileCatalog(Element namedElement) {
        this.namedElement = namedElement;
    }

    public Element getNamedElement() {
        return this.namedElement;
    }

    public Stereotype lookupStereotype(String profileName, String stereotypeName) throws NotFoundException {
        return this.lookupStereotypeInAppliedProfile(profileName, stereotypeName);
    }

    public Stereotype lookupStereotypeInAppliedProfile(String profileName, String stereotypeName) throws NotFoundException {
        Profile profile = this.namedElement.getNearestPackage().getAppliedProfile(profileName, true);
        if (profile == null) {
            throw new NotFoundException("Profile not found '" + profileName + "'.");
        }
        Stereotype stereotype = profile.getOwnedStereotype(stereotypeName, true);
        if (stereotype == null) {
            throw new NotFoundException("Stereotype not found '" + stereotypeName + "'.");
        }
        return stereotype;
    }

    @Override
    public List<Profile> getProfiles() {
        Package nearestPackage = this.namedElement.getNearestPackage();
        if (nearestPackage == null) {
            return Collections.emptyList();
        }
        EList allProfileApplications = nearestPackage.getAllProfileApplications();
        if (allProfileApplications.isEmpty()) {
            return Collections.emptyList();
        }
        List res = Lists.transform((List)allProfileApplications, ProfileFunctions.PROFILE_APPLICATION_GETAPPLIEDPROFILE);
        return res;
    }

    @Override
    public List<Stereotype> getStereotypes() {
        List<Profile> profiles = this.getProfiles();
        ArrayList<Stereotype> sterotypes = new ArrayList<Stereotype>();
        for (Profile profile : profiles) {
            sterotypes.addAll((Collection<Stereotype>)profile.getOwnedStereotypes());
        }
        return sterotypes;
    }

    @Override
    public List<String> getProfileNames() {
        Package nearestPackage = this.namedElement.getNearestPackage();
        if (nearestPackage == null) {
            return Collections.emptyList();
        }
        EList allProfileApplications = nearestPackage.getAllProfileApplications();
        if (allProfileApplications.isEmpty()) {
            return Collections.emptyList();
        }
        List res = Lists.transform((List)allProfileApplications, ProfileFunctions.PROFILE_APPLICATION_PROFILE_NAME);
        return res;
    }

    @Override
    public List<String> getStereotypeNames() {
        List res = Lists.transform(this.getStereotypes(), ProfileFunctions.STEROTYPE_NAME);
        return res;
    }

    @Override
    public List<String> getProfileQualifiedNames() {
        Package nearestPackage = this.namedElement.getNearestPackage();
        if (nearestPackage == null) {
            return Collections.emptyList();
        }
        EList allProfileApplications = nearestPackage.getAllProfileApplications();
        if (allProfileApplications.isEmpty()) {
            return Collections.emptyList();
        }
        List res = Lists.transform((List)allProfileApplications, ProfileFunctions.PROFILE_APPLICATION_PROFILE_QUALIFIEDNAME);
        return res;
    }

    @Override
    public List<String> getStereotypeQualifiedNames() {
        List res = Lists.transform(this.getStereotypes(), ProfileFunctions.STEROTYPE_QUALIFIEDNAME);
        return res;
    }

    @Override
    public List<String> getAllStereotypeNames() {
        return null;
    }
}

