/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.sequence.edit.helpers.AnchorHelper;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageCreateEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageFoundEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageLostEditPart;
import org.eclipse.papyrus.uml.service.types.element.UMLDIElementTypes;

public class CInteractionEditPart
extends InteractionEditPart {
    public CInteractionEditPart(View view) {
        super(view);
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        ConnectionAnchor sourceAnchor = this.createAnchor(request, (IElementType)UMLDIElementTypes.MESSAGE_FOUND_EDGE, "Message_FoundEdge", MessageFoundEditPart.class);
        if (sourceAnchor == null) {
            sourceAnchor = super.getSourceConnectionAnchor(request);
        }
        return sourceAnchor;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connEditPart) {
        String terminal;
        if (connEditPart instanceof MessageFoundEditPart && (terminal = AnchorHelper.getAnchorId(this.getEditingDomain(), connEditPart, true)).length() > 0) {
            PrecisionPoint pt = BaseSlidableAnchor.parseTerminalString((String)terminal);
            return new AnchorHelper.InnerPointAnchor(this.getFigure(), pt);
        }
        ConnectionAnchor sourceConnectionAnchor = super.getSourceConnectionAnchor(connEditPart);
        return sourceConnectionAnchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        ConnectionAnchor targetAnchor = this.createAnchor(request, (IElementType)UMLDIElementTypes.MESSAGE_LOST_EDGE, "Message_LostEdge", MessageLostEditPart.class);
        if (targetAnchor == null) {
            targetAnchor = super.getTargetConnectionAnchor(request);
        }
        return targetAnchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connEditPart) {
        String terminal;
        if ((connEditPart instanceof MessageLostEditPart || connEditPart instanceof MessageCreateEditPart) && (terminal = AnchorHelper.getAnchorId(this.getEditingDomain(), connEditPart, false)).length() > 0) {
            PrecisionPoint pt = BaseSlidableAnchor.parseTerminalString((String)terminal);
            return new AnchorHelper.InnerPointAnchor(this.getFigure(), pt);
        }
        ConnectionAnchor targetConnectionAnchor = super.getTargetConnectionAnchor(connEditPart);
        return targetConnectionAnchor;
    }

    private ConnectionAnchor createAnchor(Request request, IElementType elementType, String visualId, Class<?> messageType) {
        ReconnectRequest reconnectRequest;
        ConnectionEditPart connectionEditPart;
        if (request instanceof CreateUnspecifiedTypeConnectionRequest) {
            CreateUnspecifiedTypeConnectionRequest createRequest = (CreateUnspecifiedTypeConnectionRequest)request;
            List relationshipTypes = createRequest.getElementTypes();
            for (Object obj : relationshipTypes) {
                if (!elementType.equals(obj)) continue;
                return this.createAnchor(createRequest.getLocation().getCopy());
            }
        } else if (request instanceof CreateConnectionViewRequest) {
            CreateConnectionViewRequest createRequest = (CreateConnectionViewRequest)request;
            CreateConnectionViewRequest.ConnectionViewDescriptor connectionViewDescriptor = createRequest.getConnectionViewDescriptor();
            if (connectionViewDescriptor != null && visualId.equals(connectionViewDescriptor.getSemanticHint())) {
                return this.createAnchor(createRequest.getLocation().getCopy());
            }
        } else if (request instanceof ReconnectRequest && messageType.isInstance(connectionEditPart = (reconnectRequest = (ReconnectRequest)request).getConnectionEditPart()) && request instanceof LocationRequest) {
            return this.createAnchor(((LocationRequest)request).getLocation().getCopy());
        }
        return null;
    }

    private ConnectionAnchor createAnchor(Point location) {
        return AnchorHelper.InnerPointAnchor.createAnchorAtLocation(this.getFigure(), new PrecisionPoint(location));
    }

    public boolean isSelectable() {
        return false;
    }

    public void showTargetFeedback(Request request) {
        ChangeBoundsRequest changeBoundsRequest;
        if (request instanceof ChangeBoundsRequest && (changeBoundsRequest = (ChangeBoundsRequest)request).getEditParts().get(0) instanceof LifelineEditPart) {
            changeBoundsRequest.setMoveDelta(new Point(changeBoundsRequest.getMoveDelta().x, 0));
        }
        super.showTargetFeedback(request);
    }
}

