/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui.pr;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.op.MergeOperation;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.ui.internal.branch.BranchOperationUI;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.mylyn.internal.github.core.pr.PullRequestComposite;
import org.eclipse.mylyn.internal.github.core.pr.PullRequestConnector;
import org.eclipse.mylyn.internal.github.core.pr.PullRequestUtils;
import org.eclipse.mylyn.internal.github.ui.GitHubUi;
import org.eclipse.mylyn.internal.github.ui.TaskDataHandler;
import org.eclipse.mylyn.internal.github.ui.pr.Messages;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class MergePullRequestHandler
extends TaskDataHandler {
    public static final String ID = "org.eclipse.mylyn.github.ui.command.mergePullRequest";

    public Object execute(final ExecutionEvent event) throws ExecutionException {
        final TaskData data = this.getTaskData(event);
        if (data == null) {
            return null;
        }
        Job job = new Job(MessageFormat.format(Messages.MergePullRequestHandler_MergeJob, data.getTaskId())){

            protected IStatus run(IProgressMonitor monitor) {
                PullRequestComposite prComp = PullRequestConnector.getPullRequest((TaskData)data);
                if (prComp == null) {
                    return Status.CANCEL_STATUS;
                }
                PullRequest request = prComp.getRequest();
                Repository repo = PullRequestUtils.getRepository((PullRequest)request);
                if (repo == null) {
                    return Status.CANCEL_STATUS;
                }
                String target = request.getBase().getRef();
                String branchName = PullRequestUtils.getBranchName((PullRequest)request);
                try {
                    Ref sourceRef = repo.getRef(branchName);
                    if (sourceRef != null) {
                        if (!PullRequestUtils.isCurrentBranch((String)target, (Repository)repo)) {
                            monitor.setTaskName(MessageFormat.format(Messages.MergePullRequestHandler_TaskCheckout, target));
                            BranchOperationUI.checkout((Repository)repo, (String)target).run((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                        monitor.setTaskName(MessageFormat.format(Messages.MergePullRequestHandler_TaskMerge, branchName, target));
                        new MergeOperation(repo, branchName).execute((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        MergePullRequestHandler.this.executeCallback(event);
                    }
                }
                catch (IOException e) {
                    GitHubUi.logError(e);
                }
                catch (CoreException e) {
                    GitHubUi.logError(e);
                }
                return Status.OK_STATUS;
            }
        };
        this.schedule(job, event);
        return null;
    }
}

