/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.editor.ui.dependencies;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.libra.framework.editor.core.IOSGiFrameworkAdmin;
import org.eclipse.libra.framework.editor.core.model.IBundle;
import org.eclipse.libra.framework.editor.ui.internal.AbstractBundleEditorPage;
import org.eclipse.libra.framework.editor.ui.internal.EditorUIPlugin;
import org.eclipse.libra.framework.editor.ui.internal.SearchControl;
import org.eclipse.libra.framework.editor.ui.internal.SearchTextHistory;
import org.eclipse.libra.framework.editor.ui.internal.dependencies.BundleDependencyContentProvider;
import org.eclipse.libra.framework.editor.ui.internal.dependencies.BundleDependencyLabelProvider;
import org.eclipse.libra.framework.editor.ui.internal.dependencies.FocusedBundleDependencyLayoutAlgorithm;
import org.eclipse.libra.framework.editor.ui.overview.BundleInformationEditorPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.internal.browser.ImageResource;
import org.eclipse.wst.server.ui.ServerUICore;
import org.eclipse.wst.server.ui.internal.editor.ServerEditorPartInput;
import org.eclipse.wst.server.ui.internal.editor.ServerResourceCommandManager;
import org.eclipse.zest.core.viewers.AbstractZoomableViewer;
import org.eclipse.zest.core.viewers.GraphViewer;
import org.eclipse.zest.core.viewers.IZoomableWorkbenchPart;
import org.eclipse.zest.core.viewers.ZoomContributionViewItem;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.CompositeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalShift;
import org.eclipse.zest.layouts.algorithms.RadialLayoutAlgorithm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleDependencyEditorPage
extends AbstractBundleEditorPage
implements IZoomableWorkbenchPart {
    private GraphViewer viewer;
    private BundleDependencyContentProvider contentProvider;
    private BundleDependencyLabelProvider labelProvider;
    private ZoomContributionViewItem zoomContributionItem;
    private SearchControl searchControl;
    private Action refreshAction;
    private IToolBarManager toolBarManager;
    private final SearchTextHistory history = new SearchTextHistory();
    private Action forwardAction;
    private Action backAction;
    private ServerResourceCommandManager commandManager;

    @Override
    protected void createBundleContent(Composite parent) {
        this.mform = new ManagedForm(parent);
        this.setManagedForm((IManagedForm)this.mform);
        this.sform = this.mform.getForm();
        FormToolkit toolkit = this.mform.getToolkit();
        this.sform.setText("Bundle Dependency Graph");
        this.sform.setImage(ServerUICore.getLabelProvider().getImage((Object)this.getServer()));
        this.sform.setExpandHorizontal(true);
        this.sform.setExpandVertical(true);
        toolkit.decorateFormHeading(this.sform.getForm());
        Composite body = this.sform.getBody();
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        body.setLayout((Layout)layout);
        Composite configComposite = toolkit.createComposite(body);
        layout.marginLeft = 6;
        layout.marginTop = 6;
        layout.numColumns = 2;
        configComposite.setLayoutData((Object)new GridData(1040));
        configComposite.setLayout((Layout)layout);
        Section expandableComposite = toolkit.createSection(configComposite, 264);
        layout = new GridLayout();
        expandableComposite.setLayout((Layout)layout);
        expandableComposite.setLayoutData((Object)new GridData(2));
        expandableComposite.setFont(body.getFont());
        expandableComposite.setBackground(body.getBackground());
        expandableComposite.setText("Configuration");
        Composite composite = toolkit.createComposite((Composite)expandableComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginRight = 0;
        composite.setLayout((Layout)layout);
        expandableComposite.setClient((Control)composite);
        final Button servicesButton = toolkit.createButton(composite, "Services", 16);
        servicesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BundleDependencyEditorPage.this.contentProvider.setShowServices(servicesButton.getSelection());
                new BundleDependencyUpdateJob(false).schedule(200L);
            }
        });
        final Button packagesButton = toolkit.createButton(composite, "Packages", 16);
        packagesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BundleDependencyEditorPage.this.contentProvider.setShowPackage(packagesButton.getSelection());
                new BundleDependencyUpdateJob(false).schedule(200L);
            }
        });
        packagesButton.setSelection(true);
        new Label(composite, 0);
        Label dependenciesLabel = toolkit.createLabel(composite, "Dependencies");
        dependenciesLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        toolkit.createLabel(composite, "Incoming");
        final Spinner incomingSpinner = new Spinner(composite, 0);
        incomingSpinner.setMinimum(0);
        incomingSpinner.setIncrement(1);
        incomingSpinner.setMaximum(20);
        incomingSpinner.setSelection(1);
        GridData data = new GridData(128);
        incomingSpinner.setLayoutData((Object)data);
        incomingSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BundleDependencyEditorPage.this.contentProvider.setIncomingDependencyDegree(incomingSpinner.getSelection());
                new BundleDependencyUpdateJob(false).schedule(200L);
            }
        });
        toolkit.createLabel(composite, "Outgoing");
        final Spinner outgoingSpinner = new Spinner(composite, 0);
        outgoingSpinner.setMinimum(0);
        outgoingSpinner.setIncrement(1);
        outgoingSpinner.setMaximum(20);
        outgoingSpinner.setSelection(1);
        data = new GridData(128);
        outgoingSpinner.setLayoutData((Object)data);
        outgoingSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BundleDependencyEditorPage.this.contentProvider.setOutgoingDependencyDegree(outgoingSpinner.getSelection());
                new BundleDependencyUpdateJob(false).schedule(200L);
            }
        });
        Label separator = new Label(configComposite, 0);
        separator.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1"));
        data = new GridData(1168);
        data.widthHint = 1;
        separator.setLayoutData((Object)data);
        toolkit.paintBordersFor((Composite)expandableComposite);
        layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        body.setLayout((Layout)layout);
        this.viewer = new GraphViewer(body, 0);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setConnectionStyle(2);
        CompositeLayoutAlgorithm layoutAlgorithm = new CompositeLayoutAlgorithm(3, new LayoutAlgorithm[]{new RadialLayoutAlgorithm(3), new HorizontalShift(3)});
        this.searchControl = new SearchControl("Find", this.getManagedForm());
        this.contentProvider = new BundleDependencyContentProvider(this.viewer, this.searchControl);
        FocusedBundleDependencyLayoutAlgorithm la = new FocusedBundleDependencyLayoutAlgorithm(3, layoutAlgorithm, this.contentProvider);
        this.viewer.setLayoutAlgorithm((LayoutAlgorithm)la);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.contentProvider);
        this.viewer.setFilters(new ViewerFilter[0]);
        this.labelProvider = new BundleDependencyLabelProvider(this.contentProvider, toolkit);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (selection instanceof IBundle) {
                    IBundle bundle = (IBundle)selection;
                    BundleDependencyEditorPage.this.setSelection(bundle);
                }
            }
        });
        this.toolBarManager = this.sform.getToolBarManager();
        this.toolBarManager.add((IContributionItem)this.searchControl);
        this.backAction = new Action("Back"){

            public void run() {
                BundleDependencyEditorPage.this.searchControl.getSearchText().setText(BundleDependencyEditorPage.this.history.back());
                this.setEnabled(BundleDependencyEditorPage.this.history.canBack());
                BundleDependencyEditorPage.this.forwardAction.setEnabled(BundleDependencyEditorPage.this.history.canForward());
                BundleDependencyEditorPage.this.toolBarManager.update(true);
                new BundleDependencyUpdateJob(true).schedule();
            }
        };
        this.backAction.setImageDescriptor(ImageResource.getImageDescriptor((String)"IMG_ELCL_NAV_BACKWARD"));
        this.backAction.setHoverImageDescriptor(ImageResource.getImageDescriptor((String)"IMG_CLCL_NAV_BACKWARD"));
        this.backAction.setDisabledImageDescriptor(ImageResource.getImageDescriptor((String)"IMG_DLCL_NAV_BACKWARD"));
        this.backAction.setEnabled(false);
        this.toolBarManager.add((IAction)this.backAction);
        this.forwardAction = new Action("Forward"){

            public void run() {
                BundleDependencyEditorPage.this.searchControl.getSearchText().setText(BundleDependencyEditorPage.this.history.forward());
                this.setEnabled(BundleDependencyEditorPage.this.history.canForward());
                BundleDependencyEditorPage.this.backAction.setEnabled(BundleDependencyEditorPage.this.history.canBack());
                BundleDependencyEditorPage.this.toolBarManager.update(true);
                new BundleDependencyUpdateJob(true).schedule();
            }
        };
        this.forwardAction.setImageDescriptor(ImageResource.getImageDescriptor((String)"IMG_ELCL_NAV_FORWARD"));
        this.forwardAction.setHoverImageDescriptor(ImageResource.getImageDescriptor((String)"IMG_CLCL_NAV_FORWARD"));
        this.forwardAction.setDisabledImageDescriptor(ImageResource.getImageDescriptor((String)"IMG_DLCL_NAV_FORWARD"));
        this.forwardAction.setEnabled(false);
        this.toolBarManager.add((IAction)this.forwardAction);
        this.refreshAction = new Action("Refresh from server", ImageResource.getImageDescriptor((String)"IMG_ELCL_NAV_REFRESH")){

            public void run() {
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask("Updating bundle status from server", 1);
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                BundleDependencyEditorPage.this.clearStatus();
                                IOSGiFrameworkAdmin admin = (IOSGiFrameworkAdmin)BundleDependencyEditorPage.this.getServer().getOriginal().loadAdapter(IOSGiFrameworkAdmin.class, monitor);
                                if (admin == null) {
                                    IStatus status = EditorUIPlugin.newErrorStatus("Bundle Dependency Graph editor part is not integrated with the runtime.");
                                    EditorUIPlugin.log(status);
                                    BundleDependencyEditorPage.this.setStatus(status);
                                }
                                try {
                                    Map allBundles = admin.getBundles(monitor);
                                    BundleDependencyEditorPage.this.refresh(allBundles);
                                }
                                catch (CoreException e) {
                                    EditorUIPlugin.log(e);
                                    BundleDependencyEditorPage.this.setStatus(e.getStatus());
                                }
                            }
                        });
                        monitor.worked(1);
                    }
                };
                try {
                    ProgressMonitorDialog context = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
                    context.run(true, true, runnable);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
            }
        };
        this.toolBarManager.add((IAction)this.refreshAction);
        this.sform.updateToolBar();
        this.initPopupMenu();
        this.searchControl.getSearchText().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (!(e.character != '\r' && e.character != '\n' || "type filter text".equals(BundleDependencyEditorPage.this.searchControl.getSearchText().getText()))) {
                    BundleDependencyEditorPage.this.history.add(BundleDependencyEditorPage.this.searchControl.getSearchText().getText());
                    BundleDependencyEditorPage.this.forwardAction.setEnabled(BundleDependencyEditorPage.this.history.canForward());
                    BundleDependencyEditorPage.this.backAction.setEnabled(BundleDependencyEditorPage.this.history.canBack());
                    BundleDependencyEditorPage.this.toolBarManager.update(true);
                    new BundleDependencyUpdateJob(true).schedule();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.searchControl.getSearchText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if ("".equals(BundleDependencyEditorPage.this.searchControl.getSearchText().getText())) {
                    new BundleDependencyUpdateJob(true).schedule();
                }
            }
        });
    }

    private void setSelection(IBundle bundle) {
        this.setSelection(bundle.getSymbolicName(), bundle.getVersion());
    }

    private void setSelection(String bundle, String version) {
        String filterText = String.valueOf(bundle) + " (" + version + ")";
        this.searchControl.getSearchText().setText(filterText);
        this.history.add(filterText);
        this.forwardAction.setEnabled(this.history.canForward());
        this.backAction.setEnabled(this.history.canBack());
        this.toolBarManager.update(true);
        new BundleDependencyUpdateJob(true).schedule();
    }

    public AbstractZoomableViewer getZoomableViewer() {
        return this.viewer;
    }

    private void initPopupMenu() {
        this.zoomContributionItem = new ZoomContributionViewItem((IZoomableWorkbenchPart)this);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                BundleDependencyEditorPage.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
        if (!this.viewer.getSelection().isEmpty()) {
            manager.add((IAction)new Action("Show Bundle Overview"){

                public void run() {
                    Object obj = ((IStructuredSelection)BundleDependencyEditorPage.this.viewer.getSelection()).getFirstElement();
                    if (obj instanceof IBundle) {
                        BundleDependencyEditorPage.this.openDependencyPage((IBundle)obj);
                    }
                }
            });
            manager.add((IContributionItem)new Separator());
        }
        manager.add((IContributionItem)this.zoomContributionItem);
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.commandManager = ((ServerEditorPartInput)input).getServerCommandManager();
    }

    public void showDependenciesForBundle(String bundle, String version) {
        this.setSelection(bundle, version);
    }

    public void openDependencyPage(IBundle bundle) {
        BundleInformationEditorPage infoPage = this.openInformationPage();
        if (infoPage != null) {
            this.commandManager.getServerEditor().setActiveEditor((IEditorPart)infoPage);
            infoPage.showOverviewForBundle(bundle);
        }
    }

    public void refresh(Map<Long, IBundle> bundles) {
        if (bundles != null && !bundles.equals(this.viewer.getInput())) {
            this.contentProvider.setBundles(bundles);
            this.viewer.setInput(bundles.values());
            BundleInformationEditorPage infoPage = this.openInformationPage();
            if (infoPage != null) {
                infoPage.refresh(bundles);
            }
        }
    }

    private BundleInformationEditorPage openInformationPage() {
        IEditorPart[] parts;
        IEditorPart[] iEditorPartArray = parts = this.commandManager.getServerEditor().findEditors(this.getEditorInput());
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorPart part = iEditorPartArray[n2];
            if (part instanceof BundleInformationEditorPage) {
                return (BundleInformationEditorPage)part;
            }
            ++n2;
        }
        return null;
    }

    @Override
    protected void enablePage() {
        super.enablePage();
        this.setInfoStatus("Click the 'Refresh' button for fetching data from server.");
    }

    class BundleDependencyUpdateJob
    extends Job {
        private final boolean deleteSelection;

        public BundleDependencyUpdateJob(boolean deleteSelection) {
            super("Updating Bundle Dependency Graph");
            this.deleteSelection = deleteSelection;
        }

        protected IStatus run(IProgressMonitor monitor) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    BundleDependencyEditorPage.this.contentProvider.clearSelection();
                    if (BundleDependencyUpdateJob.this.deleteSelection) {
                        BundleDependencyEditorPage.this.viewer.setSelection((ISelection)new StructuredSelection());
                    }
                    BundleDependencyEditorPage.this.viewer.refresh(true);
                    BundleDependencyEditorPage.this.viewer.getGraphControl().applyLayout();
                }
            });
            return Status.OK_STATUS;
        }
    }
}

