/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.search.query;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jubula.client.core.businessprocess.TestDataCubeBP;
import org.eclipse.jubula.client.core.model.IDataSetPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITDManager;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.utils.ModelParamValueConverter;
import org.eclipse.jubula.client.ui.rcp.search.data.SearchOptions;
import org.eclipse.jubula.client.ui.rcp.search.data.TypeName;
import org.eclipse.jubula.client.ui.rcp.search.query.AbstractTraverserQuery;

public class TestDataQuery
extends AbstractTraverserQuery {
    public TestDataQuery(SearchOptions searchData) {
        super(searchData, "org.eclipse.jubula.client.ui.rcp.views.DataSetView");
    }

    public IStatus run(IProgressMonitor monitor) {
        this.setMonitor(monitor);
        this.traverse();
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        this.searchInCentralTestData(this.collectCentralTestData());
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        this.finished();
        return Status.OK_STATUS;
    }

    @Override
    protected boolean operate(INodePO node) {
        IParamNodePO paramNode;
        if (node instanceof IParamNodePO && this.matchingSearchType(node) && this.containsTestDataValue((IParameterInterfacePO)(paramNode = (IParamNodePO)node))) {
            this.add((INodePO)paramNode);
        }
        return true;
    }

    private Set<IParameterInterfacePO> collectCentralTestData() {
        List<TypeName> types = this.getSearchOptions().getSelectedSearchableTypes();
        IProgressMonitor monitor = this.getMonitor();
        monitor.beginTask("Collecting central test data elements...", types.size());
        HashSet<IParameterInterfacePO> centralTestData = new HashSet<IParameterInterfacePO>();
        for (TypeName type : types) {
            Class<? extends IPersistentObject> searchType = type.getType();
            if (!INodePO.class.isAssignableFrom(searchType) && ITestDataCubePO.class.isAssignableFrom(searchType)) {
                IProjectPO cProject = GeneralStorage.getInstance().getProject();
                centralTestData.addAll(Arrays.asList(TestDataCubeBP.getAllTestDataCubesFor((IProjectPO)cProject)));
            }
            monitor.worked(1);
            if (monitor.isCanceled()) break;
        }
        return centralTestData;
    }

    private void searchInCentralTestData(Set<IParameterInterfacePO> centralTestData) {
        IProgressMonitor monitor = this.getMonitor();
        for (IParameterInterfacePO testDataCube : centralTestData) {
            if (this.containsTestDataValue(testDataCube)) {
                this.add(testDataCube);
            }
            monitor.worked(1);
            if (!monitor.isCanceled()) continue;
            return;
        }
    }

    private boolean containsTestDataValue(IParameterInterfacePO paramObj) {
        List usedParameters = paramObj.getParameterList();
        IParameterInterfacePO refDataCube = paramObj.getReferencedDataCube();
        ITDManager testDataManager = paramObj.getDataManager();
        for (IDataSetPO dataSet : testDataManager.getDataSets()) {
            for (IParamDescriptionPO paramDesc : usedParameters) {
                ModelParamValueConverter converter;
                String value;
                String testData;
                IParamDescriptionPO dataCubeParam;
                int column = testDataManager.findColumnForParam(paramDesc.getUniqueId());
                if (refDataCube != null && (dataCubeParam = refDataCube.getParameterForName(paramDesc.getName())) != null) {
                    column = testDataManager.findColumnForParam(dataCubeParam.getUniqueId());
                }
                if (column == -1 || column >= dataSet.getColumnCount() || (testData = dataSet.getValueAt(column)) == null || (value = (converter = new ModelParamValueConverter(testData, paramObj, null)).getGuiString()) == null || !this.matchSearchString(value)) continue;
                return true;
            }
        }
        return false;
    }
}

