/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.db.TestCaseBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAbstractContainerPO;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecObjContPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.IEditorOperation;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.dialogs.InputDialog;
import org.eclipse.jubula.client.ui.rcp.editors.TestCaseEditor;
import org.eclipse.jubula.client.ui.rcp.handlers.AbstractNewHandler;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.utils.NodeTargetCalculator;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;
import org.eclipse.swt.widgets.Control;

public class NewTestCaseHandlerTCEditor
extends AbstractNewHandler {
    public Object executeImpl(ExecutionEvent event) {
        final TestCaseEditor tce = (TestCaseEditor)Plugin.getActiveEditor();
        if (!(tce.getTreeViewer().getSelection() instanceof IStructuredSelection)) {
            return null;
        }
        tce.getEditorHelper().doEditorOperation(new IEditorOperation(){

            @Override
            public void run(IPersistentObject workingPo) {
                INodePO selectedNode = (INodePO)((IStructuredSelection)tce.getTreeViewer().getSelection()).getFirstElement();
                ISpecTestCasePO cfr_ignored_0 = (ISpecTestCasePO)workingPo;
                InputDialog dialog = new InputDialog(NewTestCaseHandlerTCEditor.this.getActiveShell(), Messages.NewTestCaseActionTCTitle, "New Test Case", Messages.NewTestCaseActionTCMessage, Messages.RenameActionTCLabel, Messages.RenameActionTCError, Messages.NewTestCaseActionDoubleTCName, "newTestCaseDialog.gif", Messages.NewTestCaseActionTCShell, false);
                dialog.setHelpAvailable(true);
                dialog.create();
                Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.dialogTestcaseAddNewContextId");
                DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
                dialog.open();
                ISpecTestCasePO newSpecTC = null;
                if (dialog.getReturnCode() == 0) {
                    String tcName = dialog.getName();
                    ICategoryPO parent = ISpecObjContPO.TCB_ROOT_NODE;
                    try {
                        newSpecTC = TestCaseBP.createNewSpecTestCase((String)tcName, (INodePO)parent);
                        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)newSpecTC, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.all);
                    }
                    catch (PMException e) {
                        PMExceptionHandler.handlePMExceptionForMasterSession(e);
                    }
                    catch (ProjectDeletedException projectDeletedException) {
                        PMExceptionHandler.handleProjectDeletedException();
                    }
                }
                if (newSpecTC != null) {
                    NodeTargetCalculator.NodeTarget place = NewTestCaseHandlerTCEditor.getPositionToInsert(selectedNode, tce.getTreeViewer().getExpandedState((Object)selectedNode));
                    if (place == null) {
                        return;
                    }
                    try {
                        ISpecTestCasePO workNewSpecTC = (ISpecTestCasePO)tce.getEditorHelper().getEditSupport().createWorkVersion((IPersistentObject)newSpecTC);
                        IExecTestCasePO newExecTC = TestCaseBP.addReferencedTestCase((EditSupport)tce.getEditorHelper().getEditSupport(), (INodePO)place.getNode(), (ISpecTestCasePO)workNewSpecTC, (Integer)place.getPos());
                        tce.getEditorHelper().setDirty(true);
                        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)newExecTC, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.all);
                    }
                    catch (PMException e) {
                        PMExceptionHandler.handlePMExceptionForEditor(e, tce);
                    }
                }
            }
        });
        return null;
    }

    public static NodeTargetCalculator.NodeTarget getPositionToInsert(INodePO node, boolean exp) {
        if (Plugin.getDefault().getPreferenceStore().getBoolean("NODE_INSERT_KEY")) {
            return NodeTargetCalculator.calcNodeTarget(null, node, 2, exp);
        }
        if (node instanceof IAbstractContainerPO || node instanceof ISpecTestCasePO || node instanceof ITestSuitePO) {
            return new NodeTargetCalculator.NodeTarget(node.getNodeListSize(), node);
        }
        if (node.getParentNode() != null) {
            return new NodeTargetCalculator.NodeTarget(node.getParentNode().getNodeListSize(), node.getParentNode());
        }
        return null;
    }
}

