/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers.dnd;

import java.util.List;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.LocalSelectionTransfer;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.TCBrowserDndSupport;
import org.eclipse.jubula.client.ui.rcp.views.TestCaseBrowser;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSpecDropTargetListener
extends ViewerDropAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(TestSpecDropTargetListener.class);

    public TestSpecDropTargetListener(TestCaseBrowser view) {
        super((Viewer)view.getTreeViewer());
        boolean scrollExpand = Plugin.getDefault().getPreferenceStore().getBoolean("TREEAUTOSCROLL_PREF_KEY");
        this.setScrollExpandEnabled(scrollExpand);
    }

    public boolean performDrop(Object data) {
        LocalSelectionTransfer transfer = LocalSelectionTransfer.getInstance();
        IPersistentObject target = (IPersistentObject)this.getCurrentTarget();
        List nodesToBeMoved = transfer.getSelection().toList();
        boolean succ = TCBrowserDndSupport.moveNodes(nodesToBeMoved, target);
        TestSpecDropTargetListener.logDrop("Test Case Browser", nodesToBeMoved, target, succ);
        if (!succ) {
            return false;
        }
        LocalSelectionTransfer.getInstance().setSelection(null);
        return true;
    }

    public static void logDrop(String browser, List<INodePO> toMove, IPersistentObject target, boolean succ) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        StringBuilder str = new StringBuilder();
        str.append("\nDropping nodes in the ");
        str.append(browser);
        str.append(".\n The nodes:\n");
        str.append(toMove.toString());
        str.append("\nThe target: ");
        str.append(target.getName());
        str.append("\nSuccess: ");
        str.append(succ);
        str.append("\n");
        LOG.debug(str.toString());
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        if (LocalSelectionTransfer.getInstance().getSelection() == null) {
            return false;
        }
        if (this.getCurrentLocation() == 1 || this.getCurrentLocation() == 2) {
            return false;
        }
        LocalSelectionTransfer transfer = LocalSelectionTransfer.getInstance();
        if (transfer.getSource() != null && !transfer.getSource().equals(this.getViewer())) {
            return false;
        }
        return TCBrowserDndSupport.canMove(transfer.getSelection(), target);
    }

    public void dragOver(DropTargetEvent event) {
        super.dragOver(event);
        if (event.item != null && event.item.getData() instanceof ISpecTestCasePO) {
            event.feedback &= 0xFFFFFFEF;
        }
        if (this.getCurrentLocation() == 1 || this.getCurrentLocation() == 2) {
            event.feedback &= 0xFFFFFFEF;
        }
    }
}

