/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.templateengine;

import java.util.Arrays;
import java.util.TreeSet;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.ui.templateengine.IWizardDataPage;
import org.eclipse.cdt.ui.templateengine.Messages;
import org.eclipse.cdt.ui.templateengine.ProjectSelectionPage;
import org.eclipse.cdt.ui.templateengine.Template;
import org.eclipse.cdt.ui.templateengine.TemplateEngineUI;
import org.eclipse.cdt.ui.templateengine.TemplatesChoiceWizard;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class TemplateClassWizard
extends TemplatesChoiceWizard
implements INewWizard,
IExecutableExtension {
    public static final String WIZARD_ID = TemplateClassWizard.class.getName();
    private IWizardDataPage[] pagesBeforeTemplatePages;
    private IWizardDataPage[] pagesAfterTemplatePages;
    private IWizardDataPage[] pagesAfterTemplateSelection;
    private ProjectSelectionPage projectSelectionPage;
    private IConfigurationElement configElement;

    public TemplateClassWizard() {
        this.setWindowTitle(Messages.getString("TemplateClassWizard.0"));
    }

    @Override
    public String getListSelectionTitle() {
        return Messages.getString("TemplateClassWizard.1");
    }

    @Override
    public String getListSelectionDescription() {
        return Messages.getString("TemplateClassWizard.2");
    }

    @Override
    public String getListSelectionLabel() {
        return Messages.getString("TemplateClassWizard.3");
    }

    @Override
    protected IWizardDataPage[] getPagesBeforeTemplatePages() {
        if (this.pagesBeforeTemplatePages == null) {
            this.projectSelectionPage = new ProjectSelectionPage();
            this.projectSelectionPage.setTitle(Messages.getString("TemplateClassWizard.4"));
            this.projectSelectionPage.setDescription(Messages.getString("TemplateClassWizard.5"));
            this.projectSelectionPage.init(this.selection);
            this.pagesBeforeTemplatePages = new IWizardDataPage[]{this.projectSelectionPage};
        }
        return this.pagesBeforeTemplatePages;
    }

    @Override
    protected IWizardDataPage[] getPagesAfterTemplatePages() {
        if (this.pagesAfterTemplatePages == null) {
            this.pagesAfterTemplatePages = new IWizardDataPage[0];
        }
        return this.pagesAfterTemplatePages;
    }

    @Override
    public Template[] getTemplates() {
        TreeSet<Template> templateList = new TreeSet<Template>(TemplateCore.TEMPLATE_ID_CASE_INSENSITIVE_COMPARATOR);
        templateList.addAll(Arrays.asList(TemplateEngineUI.getDefault().getTemplates()));
        return templateList.toArray(new Template[templateList.size()]);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configElement = config;
    }

    @Override
    public boolean performFinish() {
        boolean retVal = super.performFinish();
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
        return retVal;
    }

    @Override
    protected IWizardDataPage[] getPagesAfterTemplateSelection() {
        if (this.pagesAfterTemplateSelection == null) {
            this.pagesAfterTemplateSelection = new IWizardDataPage[0];
        }
        return this.pagesAfterTemplateSelection;
    }

    @Override
    public String getDescription(Object object) {
        if (object instanceof Template) {
            return ((Template)((Object)object)).getDescription();
        }
        return "";
    }

    @Override
    public boolean showTemplatesInTreeView() {
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getTemplates();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

