/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.cdt.internal.core.AdapterUtil;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.ResourceUtil;

public abstract class AbstractResourceActionHandler
extends AbstractHandler {
    private IEvaluationContext evaluationContext;
    private IStructuredSelection selection;

    public void setSelection(ISelection selection) {
        this.selection = AbstractResourceActionHandler.convertSelection(null, selection);
    }

    public void setEnabled(Object evaluationContext) {
        this.evaluationContext = (IEvaluationContext)evaluationContext;
        this.selection = AbstractResourceActionHandler.convertSelection(this.evaluationContext, null);
    }

    protected IStructuredSelection getSelection() {
        if (this.selection == null) {
            this.selection = AbstractResourceActionHandler.convertSelection(this.evaluationContext, null);
        }
        return this.selection;
    }

    protected static IStructuredSelection getSelection(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        if (selection == null) {
            selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        }
        if (selection instanceof ITextSelection) {
            IEditorInput editorInput = HandlerUtil.getActiveEditorInputChecked((ExecutionEvent)event);
            IResource resource = ResourceUtil.getResource((IEditorInput)editorInput);
            if (resource != null) {
                return new StructuredSelection((Object)resource);
            }
            resource = ResourceUtil.getFile((IEditorInput)editorInput);
            if (resource != null) {
                return new StructuredSelection((Object)resource);
            }
        }
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    private static IStructuredSelection convertSelection(IEvaluationContext context, Object selection) {
        if (selection == null) {
            if (context == null) {
                return StructuredSelection.EMPTY;
            }
            selection = context.getVariable("activeMenuSelection");
            if (!(selection instanceof ISelection)) {
                selection = context.getVariable("selection");
            }
        }
        if (selection instanceof ITextSelection) {
            IResource resource;
            if (context == null) {
                context = AbstractResourceActionHandler.getEvaluationContext();
            }
            if ((resource = ResourceUtil.getResource((Object)context.getVariable("activeEditorInput"))) != null) {
                return new StructuredSelection((Object)resource);
            }
        }
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    private static IEvaluationContext getEvaluationContext() {
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow == null) {
            return null;
        }
        IHandlerService service = (IHandlerService)activeWindow.getService(IHandlerService.class);
        return service.getCurrentState();
    }

    protected Collection<IResource> getSelectedResources() {
        return AbstractResourceActionHandler.getSelectedResources(this.getSelection());
    }

    protected static Collection<IResource> getSelectedResources(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = AbstractResourceActionHandler.getSelection(event);
        return AbstractResourceActionHandler.getSelectedResources(selection);
    }

    private static Collection<IResource> getSelectedResources(IStructuredSelection selection) {
        LinkedHashSet<IResource> result = new LinkedHashSet<IResource>();
        for (Object obj : selection.toList()) {
            IResource resource = (IResource)AdapterUtil.adapt(obj, IResource.class);
            if (resource != null) {
                result.add(resource);
                continue;
            }
            result.addAll(AbstractResourceActionHandler.extractResourcesFromMapping(obj));
        }
        return result;
    }

    private static List<IResource> extractResourcesFromMapping(Object obj) {
        ResourceMapping mapping = (ResourceMapping)AdapterUtil.adapt((Object)obj, ResourceMapping.class);
        if (mapping != null) {
            try {
                ResourceTraversal[] traversals;
                ResourceTraversal[] resourceTraversalArray = traversals = mapping.getTraversals(null, null);
                if (traversals.length != 0) {
                    ResourceTraversal traversal = resourceTraversalArray[0];
                    return Arrays.asList(traversal.getResources());
                }
            }
            catch (CoreException e) {
                CUIPlugin.log(e);
            }
        }
        return Collections.emptyList();
    }
}

